/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.common.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mc.craig.software.regen.common.item.tooltip.hand.HandSkinToolTip;
import mc.craig.software.regen.common.objects.RItems;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.traits.TraitRegistry;
import mc.craig.software.regen.common.traits.trait.TraitBase;
import mc.craig.software.regen.util.PlayerUtil;
import mc.craig.software.regen.util.RegenDamageTypes;
import mc.craig.software.regen.util.RegenUtil;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandItem
extends class_1792 {
    public HandItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static void setSkinType(PlayerUtil.SkinType skinType, class_1799 stack) {
        stack.method_7948().method_10556("is_alex", skinType.isAlex());
    }

    public static void setPlayerName(String name, class_1799 stack) {
        stack.method_7948().method_10582("name", name);
    }

    public static String getPlayerName(class_1799 stack) {
        return stack.method_7948().method_10558("name");
    }

    public static void setSkin(byte[] skin, class_1799 stack) {
        stack.method_7948().method_10570("skin", skin);
    }

    public static byte[] getSkin(class_1799 stack) {
        return stack.method_7948().method_10547("skin");
    }

    public static boolean isAlex(class_1799 stack) {
        return stack.method_7948().method_10577("is_alex");
    }

    public static void setTrait(TraitBase traitBase, class_1799 stack) {
        stack.method_7948().method_10582("trait", TraitRegistry.TRAITS_REGISTRY.getKey(traitBase).toString());
    }

    public static TraitBase getTrait(class_1799 stack) {
        return TraitRegistry.TRAITS_REGISTRY.get(new class_2960(stack.method_7948().method_10558("trait")));
    }

    public static void setEnergy(float energy, class_1799 stack) {
        stack.method_7948().method_10548("energy", energy);
    }

    public static float getEnergy(class_1799 stack) {
        return stack.method_7948().method_10583("energy");
    }

    public static void setUUID(UUID uuid, class_1799 stack) {
        stack.method_7948().method_25927("user", uuid);
    }

    public static UUID getUUID(class_1799 stack) {
        if (stack.method_7948().method_10545("user")) {
            return stack.method_7948().method_25926("user");
        }
        return null;
    }

    public static void createHand(class_1309 livingEntity) {
        class_1799 itemStack = new class_1799((class_1935)RItems.HAND.get());
        RegenerationData.get(livingEntity).ifPresent(iRegen -> {
            HandItem.setUUID(livingEntity.method_5667(), itemStack);
            HandItem.setSkinType(iRegen.currentlyAlex() ? PlayerUtil.SkinType.ALEX : PlayerUtil.SkinType.STEVE, itemStack);
            HandItem.setTrait(iRegen.getCurrentTrait(), itemStack);
            HandItem.setEnergy(0.0f, itemStack);
            HandItem.setPlayerName(livingEntity.method_5477().getString(), itemStack);
            if (iRegen.isSkinValidForUse()) {
                HandItem.setSkin(iRegen.skin(), itemStack);
            }
            iRegen.setHandState(IRegen.Hand.CUT);
        });
        livingEntity.method_5643(new class_1282(RegenDamageTypes.getHolder(livingEntity, RegenDamageTypes.REGEN_DMG_HAND)), 3.0f);
        class_1264.method_5449((class_1937)livingEntity.method_37908(), (double)livingEntity.method_23317(), (double)livingEntity.method_23318(), (double)livingEntity.method_23321(), (class_1799)itemStack);
    }

    @NotNull
    public class_2561 method_7864(class_1799 stack) {
        if (stack.method_7948().method_10545("user") && stack.method_7948().method_10545("name")) {
            return class_2561.method_43469((String)"item.regen.hand_with_name", (Object[])new Object[]{stack.method_7948().method_10558("name") + "'s"});
        }
        return super.method_7864(stack);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        if (HandItem.getTrait(stack) != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.regen.tooltip.trait", (Object[])new Object[]{class_124.field_1080 + class_124.field_1056.toString() + HandItem.getTrait(stack).getTitle().getString()}));
        }
        tooltip.add((class_2561)class_2561.method_43469((String)"item.regen.tooltip.energy", (Object[])new Object[]{class_124.field_1080 + class_124.field_1056.toString() + RegenUtil.round(HandItem.getEnergy(stack), 2)}));
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new HandSkinToolTip(HandItem.getSkin(stack), HandItem.isAlex(stack)));
    }
}

