/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.common.item;

import java.util.Optional;
import mc.craig.software.regen.Regeneration;
import mc.craig.software.regen.common.item.tooltip.fob.FobTooltip;
import mc.craig.software.regen.common.objects.RParticles;
import mc.craig.software.regen.common.objects.RSounds;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.util.ClientUtil;
import mc.craig.software.regen.util.PlayerUtil;
import mc.craig.software.regen.util.RegenUtil;
import mc.craig.software.regen.util.constants.RMessages;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;

public class FobWatchItem
extends class_1792 {
    public FobWatchItem() {
        super(new class_1792.class_1793().method_7889(1).method_7895(12));
    }

    public static class_2487 getStackTag(class_1799 stack) {
        class_2487 stackTag = stack.method_7948();
        if (!stackTag.method_10545("is_open")) {
            stackTag.method_10556("is_open", false);
        }
        if (!stackTag.method_10545("is_gold")) {
            stackTag.method_10556("is_gold", RegenUtil.RAND.method_43056());
        }
        return stackTag;
    }

    public static boolean getEngrave(class_1799 stack) {
        return FobWatchItem.getStackTag(stack).method_10577("is_gold");
    }

    public static void setEngrave(class_1799 stack, boolean isGold) {
        FobWatchItem.getStackTag(stack).method_10556("is_gold", isGold);
    }

    public static boolean isOpen(class_1799 stack) {
        return FobWatchItem.getStackTag(stack).method_10577("is_open");
    }

    public static void setOpen(class_1799 stack, boolean isOpen) {
        FobWatchItem.getStackTag(stack).method_10556("is_open", isOpen);
    }

    public void method_7843(@NotNull class_1799 stack, @NotNull class_1937 worldIn, @NotNull class_1657 playerIn) {
        super.method_7843(stack, worldIn, playerIn);
        stack.method_7974(0);
        FobWatchItem.setOpen(stack, false);
    }

    public void method_7888(class_1799 stack, @NotNull class_1937 worldIn, @NotNull class_1297 entityIn, int itemSlot, boolean isSelected) {
        if (stack.method_7909() instanceof FobWatchItem && FobWatchItem.isOpen(stack) && entityIn.field_6012 % 600 == 0) {
            FobWatchItem.setOpen(stack, false);
        }
        super.method_7888(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        IRegen cap = RegenerationData.get((class_1309)player).orElseGet(null);
        if (!player.method_5715()) {
            if (stack.method_7919() == this.method_7841()) {
                return this.msgUsageFailed(player, RMessages.TRANSFER_EMPTY_WATCH, stack);
            }
            if (cap.regens() == this.method_7841()) {
                return this.msgUsageFailed(player, RMessages.TRANSFER_MAX_REGENS, stack);
            }
            int supply = this.method_7841() - stack.method_7919();
            int needed = this.method_7841() - cap.regens();
            int used = Math.min(supply, needed);
            if (cap.canRegenerate()) {
                FobWatchItem.setOpen(stack, true);
                PlayerUtil.sendMessage((class_1309)player, class_2561.method_43469((String)RMessages.GAINED_REGENERATIONS, (Object[])new Object[]{used}), true);
            } else if (!world.field_9236) {
                FobWatchItem.setOpen(stack, true);
                PlayerUtil.sendMessage((class_1309)player, class_2561.method_43471((String)RMessages.TIMELORD_STATUS), true);
            }
            if (!world.method_8608()) {
                class_3218 serverWorld = (class_3218)world;
                class_2338 blockPos = player.method_24515();
                serverWorld.method_14199((class_2394)RParticles.CONTAINER.get(), (double)blockPos.method_10263(), (double)blockPos.method_10264() + 1.0, (double)blockPos.method_10260(), 8, 0.5, 0.25, 0.5, 0.0);
            }
            if (used < 0) {
                Regeneration.LOGGER.warn(player.method_5477().getString() + ": Fob watch used <0 regens (supply: " + supply + ", needed:" + needed + ", used:" + used + ", capacity:" + this.method_7841() + ", damage:" + stack.method_7919() + ", regens:" + cap.regens());
            }
            stack.method_7974(stack.method_7919() + used);
            if (world.field_9236) {
                ClientUtil.playPositionedSoundRecord(RSounds.FOB_WATCH.get(), 1.0f, 2.0f);
            } else {
                FobWatchItem.setOpen(stack, true);
                cap.addRegens(used);
                cap.syncToClients(null);
            }
        } else {
            if (!cap.canRegenerate()) {
                return this.msgUsageFailed(player, RMessages.TRANSFER_NO_REGENERATIONS, stack);
            }
            if (cap.regenState() != RegenStates.ALIVE) {
                return this.msgUsageFailed(player, RMessages.TRANSFER_INVALID_STATE, stack);
            }
            if (stack.method_7919() == 0) {
                return this.msgUsageFailed(player, RMessages.TRANSFER_FULL_WATCH, stack);
            }
            stack.method_7974(stack.method_7919() - 1);
            PlayerUtil.sendMessage((class_1309)player, RMessages.TRANSFER_SUCCESSFUL, true);
            if (world.field_9236) {
                ClientUtil.playPositionedSoundRecord(class_3417.field_15102, 5.0f, 2.0f);
            } else {
                FobWatchItem.setOpen(stack, true);
                cap.extractRegens(1);
                cap.syncToClients(null);
            }
        }
        return new class_1271(class_1269.field_5811, (Object)stack);
    }

    private class_1271<class_1799> msgUsageFailed(class_1657 player, String message, class_1799 stack) {
        PlayerUtil.sendMessage((class_1309)player, message, true);
        return class_1271.method_22431((Object)stack);
    }

    public boolean method_7870(@NotNull class_1799 stack) {
        return false;
    }

    public int method_7837() {
        return 0;
    }

    public boolean method_7878(@NotNull class_1799 toRepair, @NotNull class_1799 repair) {
        return false;
    }

    public boolean method_7846() {
        return super.method_7846();
    }

    public boolean method_7887() {
        return true;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!stack.method_7986()) {
            return Optional.empty();
        }
        return Optional.of(new FobTooltip(stack.method_7919()));
    }
}

