/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.common.entities;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import mc.craig.software.regen.client.skin.SkinRetriever;
import mc.craig.software.regen.common.advancement.TriggerManager;
import mc.craig.software.regen.common.entities.Cyberman;
import mc.craig.software.regen.common.entities.Laser;
import mc.craig.software.regen.common.entities.ai.TimelordAttackGoal;
import mc.craig.software.regen.common.item.ChaliceItem;
import mc.craig.software.regen.common.item.SpawnItem;
import mc.craig.software.regen.common.objects.REntities;
import mc.craig.software.regen.common.objects.RItems;
import mc.craig.software.regen.common.objects.RSounds;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.common.regen.transitions.TransitionTypes;
import mc.craig.software.regen.common.traits.TraitRegistry;
import mc.craig.software.regen.network.messages.RemoveTimelordSkinMessage;
import mc.craig.software.regen.util.Platform;
import mc.craig.software.regen.util.RegenDamageTypes;
import mc.craig.software.regen.util.RegenUtil;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1358;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1412;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1613;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3853;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Timelord
extends class_1314
implements class_1603,
class_1915 {
    private static final class_2940<String> TYPE = class_2945.method_12791(Timelord.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> AIMING = class_2945.method_12791(Timelord.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_MALE = class_2945.method_12791(Timelord.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_SETUP = class_2945.method_12791(Timelord.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> AIMING_TICKS = class_2945.method_12791(Timelord.class, (class_2941)class_2943.field_13320);
    protected final class_1412 waterNavigator;
    protected final class_1409 groundNavigator;
    @Nullable
    protected class_1916 offers;
    @Nullable
    private class_1657 tradingPlayer;

    public Timelord(class_1937 world) {
        this(REntities.TIMELORD.get(), world);
    }

    public Timelord(class_1299<Timelord> entityEntityType, class_1937 world) {
        super(entityEntityType, world);
        this.waterNavigator = new class_1412((class_1308)this, world);
        this.groundNavigator = new class_1409((class_1308)this, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23724, 2.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(TYPE, (Object)(this.field_5974.method_43056() ? TimelordType.COUNCIL.name() : TimelordType.GUARD.name()));
        this.method_5841().method_12784(AIMING, (Object)false);
        this.method_5841().method_12784(AIMING_TICKS, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(IS_MALE, (Object)this.field_5974.method_43056());
        this.method_5841().method_12784(HAS_SETUP, (Object)false);
        this.setup();
    }

    public class_1315 method_5943(class_5425 p_35282_, class_1266 p_35283_, class_3730 p_35284_, @Nullable class_1315 p_35285_, @Nullable class_2487 p_35286_) {
        this.method_5964(this.field_5974, this.method_37908().method_8404(this.method_24515()));
        return super.method_5943(p_35282_, p_35283_, p_35284_, p_35285_, p_35286_);
    }

    public void method_5790() {
        if (!this.method_37908().field_9236) {
            if (this.method_6034() && this.method_5799()) {
                this.field_6189 = this.waterNavigator;
                this.method_5796(true);
            } else {
                this.field_6189 = this.groundNavigator;
                this.method_5796(false);
            }
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 0.5));
        this.field_6201.method_6277(9, (class_1352)new class_1358((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        if (this.getTimelordType() == TimelordType.GUARD) {
            this.field_6201.method_6277(2, (class_1352)new TimelordAttackGoal(this, 1.0, 20, 20.0f));
        }
        if (this.getTimelordType() == TimelordType.COUNCIL) {
            for (class_6880 holder : (class_6885.class_6888)class_7923.field_41178.method_40266(RegenUtil.TIMELORD_CURRENCY).get()) {
                this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.0, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)holder.comp_349()}), false));
            }
            this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 0.5));
            this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, (double)1.2f, true));
        }
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[]{Timelord.class}));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1642.class, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1613.class, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, Cyberman.class, false));
    }

    public void setup() {
        if (!this.method_37908().method_8608()) {
            RegenerationData.get((class_1309)this).ifPresent(data -> {
                data.addRegens(this.method_37908().method_8409().method_43048(12));
                class_2487 nbt = new class_2487();
                nbt.method_10548("p_red", (float)this.field_5974.method_43048(255) / 255.0f);
                nbt.method_10548("p_green", (float)this.field_5974.method_43048(255) / 255.0f);
                nbt.method_10548("p_blue", (float)this.field_5974.method_43048(255) / 255.0f);
                nbt.method_10548("s_red", (float)this.field_5974.method_43048(255) / 255.0f);
                nbt.method_10548("s_green", (float)this.field_5974.method_43048(255) / 255.0f);
                nbt.method_10548("s_blue", (float)this.field_5974.method_43048(255) / 255.0f);
                data.readStyle(nbt);
                data.setTransitionType(TransitionTypes.getRandomTimelordType());
                this.initSkin((IRegen)data);
                this.genName();
                this.method_5964(this.field_5974, this.method_37908().method_8404(this.method_24515()));
                this.method_5841().method_12778(HAS_SETUP, (Object)true);
            });
        }
    }

    @Nullable
    protected class_3414 method_5994() {
        return null;
    }

    protected void method_6108() {
        class_1299 weepingAngel;
        super.method_6108();
        if (Platform.isModLoaded("weeping_angels") && !this.method_37908().field_9236 && (weepingAngel = (class_1299)class_7923.field_41177.method_10223(new class_2960("weeping_angels", "weeping_angel"))) != null && this.method_37908().field_9229.method_43048(100) < 10) {
            class_1297 entity = weepingAngel.method_5883(this.method_37908());
            entity.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            this.method_37908().method_8649(entity);
        }
    }

    public void genName() {
        if (RegenUtil.USERNAMES.length == 0) {
            RegenUtil.setupNames();
        }
        this.method_5665((class_2561)class_2561.method_43470((String)RegenUtil.USERNAMES[this.field_5974.method_43048(RegenUtil.USERNAMES.length - 1)]));
    }

    public void method_6078(@NotNull class_1282 cause) {
        super.method_6078(cause);
        if (!this.method_37908().field_9236) {
            new RemoveTimelordSkinMessage(this).sendToAll();
        }
    }

    public void initSkin(IRegen data) {
        this.method_37908().method_8503().method_20493(() -> {
            File file = SkinRetriever.chooseRandomSkin(this.method_37908().field_9229, true, true);
            if (file != null) {
                data.setSkin(RegenUtil.fileToBytes(file));
            }
            data.setAlexSkin(true);
            data.syncToClients(null);
        });
    }

    public TimelordType getTimelordType() {
        String type = (String)this.method_5841().method_12789(TYPE);
        for (TimelordType value : TimelordType.values()) {
            if (!value.name().equals(type)) continue;
            return value;
        }
        return TimelordType.GUARD;
    }

    public void setTimelordType(TimelordType type) {
        this.method_5841().method_12778(TYPE, (Object)type.name());
    }

    public void method_5773() {
        if (!((Boolean)this.method_5841().method_12789(HAS_SETUP)).booleanValue()) {
            this.setup();
        }
        super.method_5773();
        RegenerationData.get((class_1309)this).ifPresent(data -> {
            if (!this.method_37908().field_9236) {
                if (!data.isSkinValidForUse()) {
                    this.initSkin((IRegen)data);
                    data.syncToClients(null);
                }
                if (this.field_6012 < 20) {
                    data.syncToClients(null);
                }
                if (data.regenState() == RegenStates.REGENERATING) {
                    if (data.updateTicks() == data.transitionType().getAnimationLength() / 2) {
                        this.setMale(this.field_5974.method_43056());
                        this.initSkin((IRegen)data);
                        new RemoveTimelordSkinMessage(this).sendToAll();
                    }
                    this.method_18800(0.0, 0.0, 0.0);
                    this.method_5977(true);
                    this.method_5684(true);
                    return;
                }
                this.method_5977(false);
                this.method_5684(false);
            }
        });
    }

    public float method_6017() {
        return 1.0f;
    }

    public void method_5768() {
        if (!this.method_37908().field_9236) {
            new RemoveTimelordSkinMessage(this).sendToAll();
        }
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("timelord_type", this.getTimelordType().name());
        compound.method_10556("is_male", this.male());
        compound.method_10556("setup", ((Boolean)this.method_5841().method_12789(HAS_SETUP)).booleanValue());
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("timelord_type")) {
            this.setTimelordType(TimelordType.valueOf(compound.method_10558("timelord_type")));
        }
        if (compound.method_10545("is_male")) {
            this.setMale(compound.method_10577("is_male"));
        }
        if (compound.method_10545("setup")) {
            this.method_5841().method_12778(HAS_SETUP, (Object)compound.method_10577("setup"));
        }
    }

    public boolean male() {
        return (Boolean)this.method_5841().method_12789(IS_MALE);
    }

    public void setMale(boolean male) {
        this.method_5841().method_12778(IS_MALE, (Object)male);
    }

    protected void updateTrades() {
        if (this.getTimelordType() != TimelordType.COUNCIL) {
            return;
        }
        class_1916 merchantoffers = this.method_8264();
        for (int i = this.field_5974.method_43048(7); i > 0; --i) {
            TraitRegistry.getRandomTrait().ifPresent(traitBase -> {
                class_1799 chalice = new class_1799((class_1935)RItems.GAUNTLET.get());
                ChaliceItem.setTrait(chalice, traitBase);
                class_7923.field_41178.method_40266(RegenUtil.TIMELORD_CURRENCY).flatMap(potentialCurrency -> potentialCurrency.method_40243(this.field_5974)).ifPresent(itemHolder -> {
                    class_3853.class_1652[] trades = new TimelordTrade[]{new TimelordTrade(new class_1799((class_1935)itemHolder.comp_349(), class_3532.method_15340((int)this.field_5974.method_43048(10), (int)6, (int)20)), chalice, this.field_5974.method_43048(7), 5)};
                    this.addOffersFromItemListings(merchantoffers, trades, 5);
                });
            });
        }
        class_3853.class_1652[] baseTrades = new TimelordTrade[]{new TimelordTrade(new class_1799((class_1935)class_1802.field_8477, 3), new class_1799((class_1935)RItems.ZINC.get(), 15), new class_1799((class_1935)RItems.RIFLE.get()), this.field_5974.method_43048(7), 5), new TimelordTrade(new class_1799((class_1935)class_1802.field_22020, 4), new class_1799((class_1935)RItems.ZINC.get(), 15), new class_1799((class_1935)RItems.PISTOL.get()), this.field_5974.method_43048(7), 5)};
        this.addOffersFromItemListings(merchantoffers, baseTrades, 5);
    }

    protected void addOffersFromItemListings(class_1916 merchantOffers, class_3853.class_1652[] itemListings, int p_35280_) {
        HashSet set = Sets.newHashSet();
        if (itemListings.length > p_35280_) {
            while (set.size() < p_35280_) {
                set.add(this.field_5974.method_43048(itemListings.length));
            }
        } else {
            for (int i = 0; i < itemListings.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            class_3853.class_1652 villagerTrades = itemListings[integer];
            class_1914 merchantoffer = villagerTrades.method_7246((class_1297)this, this.field_5974);
            if (merchantoffer == null) continue;
            merchantOffers.add((Object)merchantoffer);
        }
    }

    protected void method_5964(@NotNull class_5819 random, @NotNull class_1266 difficulty) {
        if (this.getTimelordType() == TimelordType.GUARD) {
            class_1792 stack = random.method_43056() ? RItems.RIFLE.get() : RItems.PISTOL.get();
            this.method_5673(class_1304.field_6169, new class_1799((class_1935)RItems.GUARD_HELMET.get()));
            this.method_5673(class_1304.field_6174, new class_1799((class_1935)RItems.GUARD_CHEST.get()));
            this.method_5673(class_1304.field_6172, new class_1799((class_1935)RItems.GUARD_LEGS.get()));
            this.method_5673(class_1304.field_6166, new class_1799((class_1935)RItems.GUARD_FEET.get()));
            this.method_6122(class_1268.field_5808, new class_1799((class_1935)stack));
        }
        if (this.getTimelordType() == TimelordType.COUNCIL) {
            boolean isMale = this.male();
            this.method_5673(class_1304.field_6169, new class_1799(isMale ? (class_1935)RItems.M_ROBES_HEAD.get() : (class_1935)RItems.F_ROBES_HEAD.get()));
            this.method_5673(class_1304.field_6174, new class_1799(isMale ? (class_1935)RItems.M_ROBES_CHEST.get() : (class_1935)RItems.F_ROBES_CHEST.get()));
            this.method_5673(class_1304.field_6172, new class_1799(isMale ? (class_1935)RItems.M_ROBES_LEGS.get() : (class_1935)RItems.F_ROBES_LEGS.get()));
            this.method_5673(class_1304.field_6166, new class_1799((class_1935)RItems.ROBES_FEET.get()));
            this.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8598));
        }
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        boolean isPistol = this.method_6118(class_1304.field_6173).method_7909() == RItems.PISTOL.get();
        Laser laser = new Laser(REntities.LASER.get(), (class_1309)this, this.method_37908());
        laser.setDamage(isPistol ? 4.0f : 10.0f);
        laser.setDamageSource(isPistol ? new class_1282(RegenDamageTypes.getHolder(this.method_37908(), RegenDamageTypes.REGEN_DMG_STASER)) : new class_1282(RegenDamageTypes.getHolder(this.method_37908(), RegenDamageTypes.REGEN_DMG_RIFLE)));
        double d0 = target.method_23320() - (double)1.1f;
        double d1 = target.method_23317() - this.method_23317();
        double d2 = d0 - laser.method_23318();
        double d3 = target.method_23321() - this.method_23321();
        float f = class_3532.method_15355((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
        laser.method_7485(d1, d2 + (double)f, d3, 1.6f, 0.0f);
        this.method_5783(isPistol ? RSounds.STASER.get() : RSounds.RIFLE.get(), 0.3f, 0.4f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)laser);
    }

    public boolean getAiming() {
        return (Boolean)this.method_5841().method_12789(AIMING);
    }

    public void setAiming(boolean isAiming) {
        this.method_5841().method_12778(AIMING, (Object)isAiming);
    }

    public float getAimingTicks() {
        return ((Float)this.method_5841().method_12789(AIMING_TICKS)).floatValue();
    }

    public void setAimingTicks(float isAiming) {
        this.method_5841().method_12778(AIMING_TICKS, (Object)Float.valueOf(isAiming));
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 interactionHand) {
        class_1799 itemstack = player.method_5998(interactionHand);
        if (itemstack.method_7909() != RItems.SPAWN_ITEM.get() && this.method_5805() && !this.isTrading() && !this.method_6109()) {
            if (!this.method_8264().isEmpty() && !this.method_37908().field_9236) {
                this.method_8259(player);
                if (player instanceof class_3222) {
                    class_3222 playerEntity = (class_3222)player;
                    TriggerManager.TIMELORD_TRADE.trigger(playerEntity);
                }
                this.method_17449(player, this.method_5476(), 1);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, interactionHand);
    }

    public class_1799 method_31480() {
        switch (this.getTimelordType()) {
            case GUARD: {
                class_1799 guardStack = new class_1799((class_1935)RItems.SPAWN_ITEM.get());
                SpawnItem.setType(guardStack, SpawnItem.Timelord.GUARD);
                return guardStack;
            }
            case COUNCIL: {
                class_1799 councilStack = new class_1799((class_1935)RItems.SPAWN_ITEM.get());
                SpawnItem.setType(councilStack, this.male() ? SpawnItem.Timelord.MALE_COUNCIL : SpawnItem.Timelord.FEMALE_COUNCIL);
                return councilStack;
            }
        }
        return null;
    }

    public class_1657 method_8257() {
        return this.tradingPlayer;
    }

    public void method_8259(@Nullable class_1657 player) {
        this.tradingPlayer = player;
    }

    public class_1916 method_8264() {
        if (this.offers == null) {
            this.offers = new class_1916();
            this.updateTrades();
        }
        return this.offers;
    }

    public void method_8261(class_1916 merchantOffers) {
    }

    public void method_8262(class_1914 merchantOffer) {
        merchantOffer.method_8244();
        if (merchantOffer.method_8256()) {
            int i = 3 + this.field_5974.method_43048(4);
            this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), i));
        }
    }

    public void method_8258(class_1799 stack) {
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public int method_19269() {
        return 0;
    }

    public void method_19271(int xp) {
    }

    public boolean method_19270() {
        return true;
    }

    public class_3414 method_18010() {
        return null;
    }

    public boolean method_38069() {
        return this.method_37908().field_9236;
    }

    public static enum TimelordType {
        COUNCIL("timelord"),
        GUARD("guards");

        private final String name;

        private TimelordType(String guard) {
            this.name = guard;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class TimelordTrade
    implements class_3853.class_1652 {
        private final class_1799 coin2;
        private final class_1799 coin;
        private final class_1799 wares;
        private final int xp;
        private final int stock;

        public TimelordTrade(class_1799 coin, class_1799 coin2, class_1799 wares, int stock, int xp) {
            this.xp = xp;
            this.stock = stock + 1;
            this.wares = wares;
            this.coin = coin;
            this.coin2 = coin2;
        }

        public TimelordTrade(class_1799 coin, class_1799 wares, int stock, int xp) {
            this(coin, class_1799.field_8037, wares, stock, xp);
        }

        public class_1914 method_7246(@NotNull class_1297 trader, @NotNull class_5819 rand) {
            return new class_1914(this.coin, this.coin2, this.wares, this.stock, this.xp, 0.0f);
        }
    }
}

