/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.common.blockentity;

import mc.craig.software.regen.common.item.HandItem;
import mc.craig.software.regen.common.objects.RItems;
import mc.craig.software.regen.common.objects.RParticles;
import mc.craig.software.regen.common.objects.RSounds;
import mc.craig.software.regen.common.objects.RTiles;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.NotNull;

public class BioContainerBlockEntity
extends class_2586
implements class_5558<BioContainerBlockEntity> {
    private final class_7094 openState = new class_7094();
    private final class_7094 closeState = new class_7094();
    private boolean updateSkin = true;
    private class_1799 hand = class_1799.field_8037;
    private boolean hasWater = false;

    public BioContainerBlockEntity(class_2338 pos, class_2680 state) {
        super(RTiles.HAND_JAR.get(), pos, state);
    }

    public static void spawnParticles(class_1937 world, class_2338 blockPos) {
        class_5819 random = world.field_9229;
        for (class_2350 direction : class_2350.values()) {
            class_2338 blockpos = blockPos.method_10093(direction);
            if (world.method_8320(blockpos).method_26216((class_1922)world, blockpos)) continue;
            class_2350.class_2351 currentDirection = direction.method_10166();
            double x = currentDirection == class_2350.class_2351.field_11048 ? 0.5 + 0.5625 * (double)direction.method_10148() : (double)random.method_43057();
            double y = currentDirection == class_2350.class_2351.field_11052 ? 0.5 + 0.5625 * (double)direction.method_10164() : (double)random.method_43057();
            double z = currentDirection == class_2350.class_2351.field_11051 ? 0.5 + 0.5625 * (double)direction.method_10165() : (double)random.method_43057();
            world.method_8406((class_2394)RParticles.CONTAINER.get(), (double)blockPos.method_10263() + x, (double)blockPos.method_10264() + y, (double)blockPos.method_10260() + z, 0.0, 0.0, 0.0);
        }
    }

    public class_7094 getOpenState() {
        return this.openState;
    }

    public class_7094 getCloseState() {
        return this.closeState;
    }

    public float getLindos() {
        return HandItem.getEnergy(this.getHand());
    }

    public void setLindos(float lindos) {
        lindos = class_3532.method_15363((float)lindos, (float)0.0f, (float)100.0f);
        HandItem.setEnergy(lindos, this.getHand());
    }

    public void tick(@NotNull class_1937 currentLevel, @NotNull class_2338 blockPos, @NotNull class_2680 blockState, @NotNull BioContainerBlockEntity bioContainerBlockEntity) {
        if (this.getHand().method_7960()) {
            this.openState.method_41325();
            if (!this.closeState.method_41327()) {
                this.closeState.method_41322(Math.toIntExact(currentLevel.method_8532()));
            }
        } else {
            this.closeState.method_41325();
            if (!this.openState.method_41327()) {
                this.openState.method_41322(Math.toIntExact(currentLevel.method_8532()));
            }
        }
        if (this.isValid(Action.CREATE)) {
            BioContainerBlockEntity.spawnParticles(currentLevel, this.field_11867);
        }
        if (currentLevel != null && currentLevel.field_9236) {
            return;
        }
        if (currentLevel.method_8510() % 77L == 0L && !this.getHand().method_7960()) {
            currentLevel.method_8396(null, this.method_11016(), RSounds.JAR_BUBBLES.get(), class_3419.field_15248, 0.2f, 0.2f);
        }
        if (this.field_11863.method_8510() % 100L == 0L && this.pendingSkinUpdate()) {
            this.setUpdateSkin(false);
        }
    }

    public boolean isValid(Action action) {
        if (action == Action.ADD) {
            return this.getHand().method_7909() == RItems.HAND.get() && this.getLindos() < 100.0f && this.hasWater;
        }
        if (action == Action.CREATE) {
            return this.getHand().method_7909() == RItems.HAND.get() && this.getLindos() >= 100.0f && this.hasWater;
        }
        return false;
    }

    public void dropHandIfPresent(class_1657 player) {
        if (!this.getHand().method_7960()) {
            if (player != null) {
                if (!player.method_7270(this.getHand())) {
                    class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260(), (class_1799)this.getHand());
                    this.clearContent();
                }
            } else {
                class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260(), (class_1799)this.getHand());
                this.clearContent();
            }
        }
        this.sendUpdates();
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        return compoundTag;
    }

    public void sendUpdates() {
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 3);
        this.method_5431();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11014(class_2487 nbt) {
        this.setLindos(nbt.method_10583("energy"));
        this.setUpdateSkin(nbt.method_10577("update_skin"));
        this.setHasWater(nbt.method_10577("hasWater"));
        super.method_11014(nbt);
        if (nbt.method_10573("HandItem", 10)) {
            this.setHand(class_1799.method_7915((class_2487)nbt.method_10562("HandItem")));
        }
    }

    public void setHasWater(boolean hasWater) {
        this.hasWater = hasWater;
    }

    public void method_11007(class_2487 compound) {
        compound.method_10548("energy", this.getLindos());
        compound.method_10556("updateSkin", this.updateSkin);
        compound.method_10556("hasWater", this.hasWater);
        compound.method_10566("HandItem", (class_2520)this.getHand().method_7953(new class_2487()));
        super.method_11007(compound);
    }

    public boolean pendingSkinUpdate() {
        return this.updateSkin;
    }

    public void setUpdateSkin(boolean updateSkin) {
        this.updateSkin = updateSkin;
    }

    public class_1799 getHand() {
        return this.hand;
    }

    public void setHand(class_1799 stack) {
        this.hand = stack;
        this.method_5431();
    }

    public void clearContent() {
        this.setHand(class_1799.field_8037);
    }

    public void method_11012() {
        super.method_11012();
    }

    public boolean hasWater() {
        return this.hasWater;
    }

    public static enum Action {
        ADD,
        CREATE;

    }
}

