/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.client.skin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.network.messages.SkinMessage;
import mc.craig.software.regen.util.ClientUtil;
import mc.craig.software.regen.util.TextureFixer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_746;

public class VisualManipulator {
    public static final HashMap<UUID, class_2960> PLAYER_SKINS = new HashMap();
    public static final HashMap<UUID, Boolean> MOJANG_BACKUP = new HashMap();

    public static void tick(class_742 playerEntity) {
        RegenerationData.get((class_1309)playerEntity).ifPresent(iRegen -> {
            class_1011 skinImage;
            boolean isHalfWay;
            byte[] skin = iRegen.skin();
            UUID uuid = playerEntity.method_5667();
            boolean validSkin = iRegen.isSkinValidForUse();
            if (!validSkin) {
                PLAYER_SKINS.remove(uuid);
                VisualManipulator.setPlayerSkinType(playerEntity, VisualManipulator.mojangIsAlex(playerEntity));
                return;
            }
            boolean bl = isHalfWay = iRegen.updateTicks() >= iRegen.transitionType().getAnimationLength() / 2;
            if ((iRegen.regenState() == RegenStates.REGENERATING && isHalfWay || iRegen.regenState() != RegenStates.REGENERATING && !VisualManipulator.hasPlayerSkin(uuid)) && (skinImage = VisualManipulator.genSkinNative(skin)) != null) {
                boolean isAlex = iRegen.currentlyAlex();
                VisualManipulator.setPlayerSkinType(playerEntity, isAlex);
                VisualManipulator.addPlayerSkin(playerEntity.method_5667(), VisualManipulator.loadImage(skinImage));
            }
        });
    }

    public static boolean mojangIsAlex(class_742 abstractClientPlayerEntity) {
        if (MOJANG_BACKUP.containsKey(abstractClientPlayerEntity.method_5667())) {
            return MOJANG_BACKUP.get(abstractClientPlayerEntity.method_5667());
        }
        if (ClientUtil.getPlayerInfo(abstractClientPlayerEntity) == null) {
            return false;
        }
        class_640 info = ClientUtil.getPlayerInfo(abstractClientPlayerEntity);
        info.method_2969();
        if (info.method_2977() == null) {
            return false;
        }
        if (info.method_2977().isEmpty()) {
            return false;
        }
        return info.method_2977().contentEquals("slim");
    }

    public static void setPlayerSkinType(class_742 player, boolean isAlex) {
        class_640 playerInfo = ClientUtil.getPlayerInfo(player);
        if (playerInfo == null) {
            return;
        }
        if (!MOJANG_BACKUP.containsKey(player.method_5667())) {
            boolean skinType = playerInfo.method_2977() == null || playerInfo.method_2977().isEmpty();
            MOJANG_BACKUP.put(player.method_5667(), !skinType);
        }
        playerInfo.field_3745 = isAlex ? "slim" : "default";
    }

    public static void sendResetMessage() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            boolean info = VisualManipulator.mojangIsAlex((class_742)player);
            new SkinMessage(new byte[0], info).send();
        }
    }

    public static class_2960 loadImage(class_1011 nativeImage) {
        class_1060 textureManager = class_310.method_1551().method_1531();
        return textureManager.method_4617("player_", new class_1043(nativeImage));
    }

    public static class_1011 genSkinNative(byte[] skinArray) {
        try {
            return TextureFixer.processLegacySkin(class_1011.method_4309((InputStream)new ByteArrayInputStream(skinArray)), "@");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean hasPlayerSkin(UUID uuid) {
        return PLAYER_SKINS.containsKey(uuid);
    }

    public static void addPlayerSkin(UUID uuid, class_2960 texture) {
        PLAYER_SKINS.put(uuid, texture);
    }

    public static void removePlayerSkin(UUID uuid) {
        PLAYER_SKINS.remove(uuid);
    }
}

