/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.client.skin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import mc.craig.software.regen.Regeneration;
import mc.craig.software.regen.client.skin.VisualManipulator;
import mc.craig.software.regen.util.Platform;
import mc.craig.software.regen.util.PlayerUtil;
import mc.craig.software.regen.util.RegenUtil;
import mc.craig.software.regen.util.SkinApi;
import mc.craig.software.regen.util.TextureFixer;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5819;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.RandomStringUtils;

public class SkinRetriever {
    public static final File SKINS_DIR = new File("./regen_data/skins");
    public static final File SKINS_DIR_SLIM = new File(SKINS_DIR, "slim");
    public static final File SKINS_DIR_SLIM_TRENDING = new File(SKINS_DIR_SLIM, "web");
    public static final File SKINS_DIR_DEFAULT = new File(SKINS_DIR, "default");
    public static final File SKINS_DIR_DEFAULT_TRENDING = new File(SKINS_DIR_DEFAULT, "web");
    public static final File SKINS_DIR_SLIM_TIMELORD = new File(SKINS_DIR, "/timelords/slim");
    public static final File SKINS_DIR_DEFAULT_TIMELORD = new File(SKINS_DIR, "/timelords/default");

    public static void folderSetup() {
        SkinRetriever.createFolder(SKINS_DIR, SKINS_DIR_DEFAULT_TIMELORD, SKINS_DIR_SLIM_TIMELORD);
        if (Platform.isClient()) {
            SkinRetriever.createFolder(SKINS_DIR_DEFAULT, SKINS_DIR_SLIM, SKINS_DIR_DEFAULT_TRENDING, SKINS_DIR_SLIM_TRENDING);
        }
    }

    public static void timelord() throws IOException {
        String[] genders;
        FileUtils.cleanDirectory((File)SKINS_DIR_DEFAULT_TIMELORD);
        FileUtils.cleanDirectory((File)SKINS_DIR_SLIM_TIMELORD);
        Regeneration.LOGGER.warn("Refreshing Timelord skins");
        for (String gender : genders = new String[]{"male", "female", "girl", "boy"}) {
            ArrayList<String> result = SkinApi.searchSkins(gender);
            for (String skin : result) {
                SkinRetriever.downloadSkinToDirectory(new URL(skin), "timelord_" + gender + "_" + RandomStringUtils.random((int)5, (boolean)true, (boolean)false), gender.equals("male") ? SKINS_DIR_DEFAULT_TIMELORD : SKINS_DIR_SLIM_TIMELORD);
            }
        }
    }

    public static boolean isAlexSkin(BufferedImage image) {
        for (int i = 0; i < 8; ++i) {
            if (SkinRetriever.hasAlpha(54, i + 20, image) && SkinRetriever.hasAlpha(55, i + 20, image)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAlpha(int x, int y, BufferedImage image) {
        int pixel = image.getRGB(x, y);
        return pixel >> 24 == 0 || (pixel & 0xFFFFFF) == 0;
    }

    public static void downloadSkinToDirectory(URL url, String filename, File specific) {
        URLConnection uc = null;
        try {
            uc = url.openConnection();
            uc.connect();
            uc = url.openConnection();
            uc.setConnectTimeout(0);
            uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
            BufferedImage img = ImageIO.read(uc.getInputStream());
            if (!specific.exists()) {
                specific.mkdirs();
            }
            Regeneration.LOGGER.info("URL: {} || Name: {} || Path: {}", new Object[]{url, filename, specific});
            ImageIO.write((RenderedImage)img, "png", new File(specific, filename + ".png"));
        }
        catch (IOException e) {
            Regeneration.LOGGER.error("Failed to Download: " + url);
            e.printStackTrace();
        }
    }

    public static void remoteSkins() throws IOException {
        FileUtils.cleanDirectory((File)SKINS_DIR_SLIM_TRENDING);
        FileUtils.cleanDirectory((File)SKINS_DIR_DEFAULT_TRENDING);
        Regeneration.LOGGER.warn("Downloading new Trending skins");
        for (JsonElement skin : SkinApi.interalApiSkins()) {
            String link = skin.getAsJsonObject().get("link").getAsString();
            String id = skin.getAsJsonObject().get("name").getAsString();
            SkinRetriever.downloadSkins(new URL(link), "web_" + id, SKINS_DIR_SLIM_TRENDING, SKINS_DIR_DEFAULT_TRENDING);
        }
    }

    public static void downloadSkins(URL url, String filename, File alexDir, File steveDir) throws IOException {
        URLConnection uc = url.openConnection();
        uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
        BufferedImage img = ImageIO.read(uc.getInputStream());
        File file = SkinRetriever.isAlexSkin(img) ? alexDir : steveDir;
        SkinRetriever.createFolder(file, steveDir, alexDir);
        Regeneration.LOGGER.info("URL: {} || Name: {} || Path: {}", new Object[]{url, filename, file.getPath()});
        ImageIO.write((RenderedImage)img, "png", new File(file, filename + ".png"));
    }

    public static void internalSkins() throws IOException {
        Regeneration.LOGGER.warn("Re-downloading internal skins");
        String packsUrl = "https://mc-api.craig.software/skins";
        JsonElement links = SkinApi.getApiData(packsUrl);
        if (links.isJsonObject()) {
            JsonArray data = links.getAsJsonObject().getAsJsonArray("data");
            for (JsonElement jsonElement : data) {
                JsonObject currentSkin = jsonElement.getAsJsonObject();
                String packName = currentSkin.get("name").getAsString();
                String downloadLink = currentSkin.get("url").getAsString();
                String destination = currentSkin.get("destination").getAsString();
                File skinPackDir = new File(SKINS_DIR + "/" + destination.replaceAll("alex", "slim").replaceAll("steve", "default"));
                SkinRetriever.createFolder(skinPackDir);
                SkinRetriever.downloadSkinToDirectory(new URL(downloadLink), packName, skinPackDir);
            }
        }
    }

    public static void writeTime() throws IOException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("update_interval", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
        try (FileWriter writer = new FileWriter(new File(SKINS_DIR, "cache_tracker.json"));){
            RegenUtil.GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
            writer.flush();
        }
    }

    public static void doDownloads(boolean isClient) throws IOException {
        SkinRetriever.folderSetup();
        SkinRetriever.writeTime();
        SkinRetriever.timelord();
        if (isClient) {
            SkinRetriever.remoteSkins();
            SkinRetriever.internalSkins();
        }
    }

    public static boolean shouldUpdateSkins() throws FileNotFoundException {
        JsonObject json;
        File cacheFile = new File(SKINS_DIR, "cache_tracker.json");
        if (!cacheFile.exists()) {
            Regeneration.LOGGER.info("Looks like no skins have been downloaded! Commencing first time set up!");
            return true;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(cacheFile)));
        try {
            json = class_3518.method_15255((Reader)br);
        }
        catch (JsonSyntaxException e) {
            Regeneration.LOGGER.error("Failed to parse the JSON file! Skins will not be updated.");
            return false;
        }
        if (!json.has("update_interval")) {
            return true;
        }
        int updateInterval = json.getAsJsonPrimitive("update_interval").getAsInt();
        long timeSinceDownloaded = json.getAsJsonPrimitive("update_interval").getAsLong();
        long hoursSince = TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - timeSinceDownloaded);
        boolean shouldDownload = hoursSince > 24L;
        Regeneration.LOGGER.info("It has been {} hours since last skin update! {}", (Object)hoursSince, (Object)(shouldDownload ? "A Skin update will commence!" : "A Skin update will not commence just now!"));
        return shouldDownload;
    }

    public static void createFolder(File ... folders) {
        for (File folder : folders) {
            if (folder.exists() || !folder.mkdirs()) continue;
            Regeneration.LOGGER.info("Setup missing Regeneration Folder: {}", (Object)folder);
        }
    }

    public static File chooseRandomSkin(class_5819 random, boolean isTimelord, boolean isAlex) {
        File skins;
        File file2 = isTimelord ? (isAlex ? SKINS_DIR_SLIM_TIMELORD : SKINS_DIR_DEFAULT_TIMELORD) : (skins = isAlex ? SKINS_DIR_SLIM : SKINS_DIR_DEFAULT);
        if (!skins.exists()) {
            SkinRetriever.folderSetup();
        }
        Collection folderFiles = FileUtils.listFiles((File)skins, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        folderFiles.removeIf(file -> !file.getName().endsWith(".png"));
        if (folderFiles.size() == 0) {
            return null;
        }
        File[] files = folderFiles.toArray(new File[0]);
        return files[random.method_43048(files.length)];
    }

    public static class_2960 fileToTexture(File file) {
        class_1011 nativeImage = null;
        try {
            nativeImage = TextureFixer.processLegacySkin(class_1011.method_4309((InputStream)new FileInputStream(file)), file.toString());
        }
        catch (IOException e) {
            Regeneration.LOGGER.error("Failed to convert file to texture: {}", (Object)e.getMessage());
        }
        return VisualManipulator.loadImage(nativeImage);
    }

    public static List<File> listAllSkins(PlayerUtil.SkinType currentSkinType) {
        File DIR;
        switch (currentSkinType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EITHER: {
                File file2 = SKINS_DIR;
                break;
            }
            case ALEX: {
                File file2 = SKINS_DIR_SLIM;
                break;
            }
            case STEVE: {
                File file2 = DIR = SKINS_DIR_DEFAULT;
            }
        }
        if (!DIR.exists()) {
            return Collections.emptyList();
        }
        Collection folderFiles = FileUtils.listFiles((File)DIR, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        folderFiles.removeIf(file -> !file.getName().endsWith(".png") || file.getName().contains("timelord_male") || file.getName().contains("timelord_female"));
        return new ArrayList<File>(folderFiles);
    }
}

