/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.client.screen.widgets;

import java.awt.Color;
import mc.craig.software.regen.client.screen.widgets.RCheckbox;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_6382;

public class ColorWidget
extends class_339 {
    protected final RCheckbox.IInteraction<ColorWidget> onPress;
    private final int radius;
    private final int textHeight;
    private int color;
    private class_342 text = null;

    public ColorWidget(class_327 font, int x, int y, int width, int textHeight, class_2561 title, int defaultColor, RCheckbox.IInteraction<ColorWidget> iInteraction) {
        super(x, y, width, width, title);
        this.radius = width / 2;
        this.color = defaultColor;
        this.text = new class_342(font, x, y + width + 10, width - textHeight - 5, textHeight, this.text, title);
        this.text.method_1888(true);
        this.textHeight = textHeight;
        this.onPress = iInteraction;
        this.text.method_1863(s -> {
            try {
                Color color = Color.decode(s);
                this.setColor(color.getRGB());
                this.updateColor();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.updateColor();
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22764) {
            for (int x = -this.radius; x < this.radius; ++x) {
                for (int y = -this.radius; y < this.radius; ++y) {
                    double distance = Math.sqrt(x * x + y * y);
                    if (distance > (double)this.radius) continue;
                    double angle = Math.atan2(y, x);
                    double degrees = Math.toDegrees(angle);
                    float hue = (float)(degrees < 0.0 ? 360.0 + degrees : degrees);
                    float saturation = (float)(distance / (double)this.radius);
                    guiGraphics.method_25294(x + this.radius + this.method_46426(), y + this.radius + this.method_46427(), x + this.radius + 1 + this.method_46426(), y + this.radius + 1 + this.method_46427(), this.hsv2rgb(hue, saturation, 1.0f));
                }
            }
        }
        this.text.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_25294(this.method_46426() + this.field_22758 - this.textHeight - 1, this.method_46427() + this.field_22758 + 9, this.method_46426() + this.field_22758, this.method_46427() + this.field_22758 + 10 + this.textHeight + 1, -6381922);
        guiGraphics.method_25294(this.method_46426() + this.field_22758 - this.textHeight, this.method_46427() + this.field_22758 + 10, this.method_46426() + this.field_22758 - 1, this.method_46427() + this.field_22758 + 10 + this.textHeight, this.color);
    }

    public void method_25348(double mouseX, double mouseY) {
        double distance = Math.sqrt(Math.pow(mouseX - (double)this.method_46426() - (double)this.radius, 2.0) + Math.pow(mouseY - (double)this.method_46427() - (double)this.radius, 2.0));
        if (distance <= (double)this.radius) {
            double angle = Math.atan2(mouseY - (double)this.method_46427() - (double)this.radius, mouseX - (double)this.method_46426() - (double)this.radius);
            double degrees = Math.toDegrees(angle);
            float hue = (float)(degrees < 0.0 ? 360.0 + degrees : degrees);
            float saturation = (float)(distance / (double)this.radius);
            this.color = this.hsv2rgb(hue, saturation, 1.0f);
            this.updateColor();
        }
        this.onPress.onPress(this);
    }

    private void updateColor() {
        this.text.method_1852(String.format("#%s", Integer.toHexString(this.color)).toUpperCase());
    }

    public int hsv2rgb(float hue, float saturation, float value) {
        float chroma = value * saturation;
        float hue1 = hue / 60.0f;
        float x = chroma * (1.0f - Math.abs(hue1 % 2.0f - 1.0f));
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        if (hue1 >= 0.0f && hue1 <= 1.0f) {
            r1 = chroma;
            g1 = x;
            b1 = 0.0f;
        } else if (hue1 >= 1.0f && hue1 <= 2.0f) {
            r1 = x;
            g1 = chroma;
            b1 = 0.0f;
        } else if (hue1 >= 2.0f && hue1 <= 3.0f) {
            r1 = 0.0f;
            g1 = chroma;
            b1 = x;
        } else if (hue1 >= 3.0f && hue1 <= 4.0f) {
            r1 = 0.0f;
            g1 = x;
            b1 = chroma;
        } else if (hue1 >= 4.0f && hue1 <= 5.0f) {
            r1 = x;
            g1 = 0.0f;
            b1 = chroma;
        } else if (hue1 >= 5.0f && hue1 <= 6.0f) {
            r1 = chroma;
            g1 = 0.0f;
            b1 = x;
        }
        float m = value - chroma;
        float r = r1 + m;
        float g = g1 + m;
        float b = b1 + m;
        return 0xFF000000 | ((int)(255.0f * r) & 0xFF) << 16 | ((int)(255.0f * g) & 0xFF) << 8 | (int)(255.0f * b) & 0xFF;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.updateColor();
    }

    public void tick() {
        this.text.method_1865();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.text.method_25404(keyCode, scanCode, modifiers);
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

