/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Objects;
import mc.craig.software.regen.client.screen.ColorScreen;
import mc.craig.software.regen.client.screen.PreferencesScreen;
import mc.craig.software.regen.client.screen.RErrorScreen;
import mc.craig.software.regen.client.screen.widgets.RCheckbox;
import mc.craig.software.regen.client.skin.SkinRetriever;
import mc.craig.software.regen.client.skin.VisualManipulator;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.network.messages.NextSkinMessage;
import mc.craig.software.regen.util.ClientUtil;
import mc.craig.software.regen.util.PlayerUtil;
import mc.craig.software.regen.util.RegenUtil;
import net.minecraft.class_1068;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_7919;

public class IncarnationScreen
extends class_437 {
    private static final class_2960 screenBackground = new class_2960("regen", "textures/gui/customizer.png");
    public static boolean isAlex = true;
    public static class_2960 currentTexture = class_1068.method_4649();
    private static PlayerUtil.SkinType currentSkinType;
    private static PlayerUtil.SkinType renderChoice;
    private static List<File> skins;
    private static int position;
    public boolean postRenderedPlayer;
    protected int imageWidth = 256;
    protected int imageHeight = 173;
    private RCheckbox excludeTrending;
    private class_342 searchField;
    private int leftPos;
    private int topPos;

    public IncarnationScreen() {
        super((class_2561)class_2561.method_43470((String)"Next Incarnation"));
    }

    public static void updateModels() {
        class_310.method_1551().method_1531().method_4615(currentTexture);
        if (!skins.isEmpty()) {
            isAlex = skins.get(position).getAbsolutePath().contains("slim");
            renderChoice = isAlex ? PlayerUtil.SkinType.ALEX : PlayerUtil.SkinType.STEVE;
            currentTexture = SkinRetriever.fileToTexture(skins.get(position));
        } else {
            IncarnationScreen.checkForMissingSkins();
        }
    }

    public static void renderWidthScaledText(String text, class_332 guiGraphics, class_327 font, float x, float y, int color, int width) {
        guiGraphics.method_51448().method_22903();
        int textWidth = font.method_1727(text);
        float scale = (float)width / (float)textWidth;
        scale = class_3532.method_15363((float)scale, (float)0.0f, (float)1.0f);
        guiGraphics.method_51448().method_46416(x, y, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_25300(class_310.method_1551().field_1772, text, 0, 0, color);
        guiGraphics.method_51448().method_22909();
    }

    private static void checkForMissingSkins() {
        if (skins.isEmpty()) {
            class_310.method_1551().method_1507((class_437)new RErrorScreen((class_2561)class_2561.method_43471((String)("No Skins for " + class_2561.method_43471((String)("regeneration.skin_type." + currentSkinType.name().toLowerCase())).getString())), (class_2561)class_2561.method_43471((String)"Please place skins in the local Directory")));
        }
    }

    public boolean method_25421() {
        return true;
    }

    private void stripTrending() {
        if (!this.excludeTrending.method_20372()) {
            skins.removeIf(file -> file.getPath().contains("web"));
        }
    }

    private void renderSkinToGui(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51448().method_22903();
        class_746 player = class_310.method_1551().field_1724;
        boolean backupSkinType = ClientUtil.isAlex((class_1297)player);
        this.postRenderedPlayer = true;
        VisualManipulator.setPlayerSkinType((class_742)class_310.method_1551().field_1724, renderChoice == PlayerUtil.SkinType.ALEX);
        class_490.method_2486((class_332)guiGraphics, (int)(this.field_22789 / 2 + 60), (int)(this.field_22790 / 2 + 20), (int)45, (float)((float)(this.leftPos + 170) - (float)mouseX), (float)((float)(this.topPos + 75 - 25) - (float)mouseY), (class_1309)class_310.method_1551().field_1724);
        this.postRenderedPlayer = false;
        VisualManipulator.setPlayerSkinType((class_742)class_310.method_1551().field_1724, backupSkinType);
        guiGraphics.method_51448().method_22909();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String s = this.searchField.method_1882();
        super.method_25410(minecraft, width, height);
        this.searchField.method_1852(s);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.searchField.method_25404(keyCode, scanCode, modifiers);
        if (keyCode == 262) {
            position = position >= skins.size() - 1 ? 0 : ++position;
            IncarnationScreen.updateModels();
        }
        if (keyCode == 263) {
            position = position > 0 ? --position : skins.size() - 1;
            IncarnationScreen.updateModels();
        }
        if (keyCode == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        RenderSystem.setShaderTexture((int)0, (class_2960)screenBackground);
        guiGraphics.method_25302(screenBackground, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderSkinToGui(guiGraphics, mouseX, mouseY);
        guiGraphics.method_25300(class_310.method_1551().field_1772, class_2561.method_43471((String)"gui.regen.current_skin").getString(), this.field_22789 / 2 + 60, this.field_22790 / 2 + 30, Color.WHITE.getRGB());
        if (!skins.isEmpty() && position < skins.size()) {
            guiGraphics.method_51448().method_22903();
            String name = skins.get(position).getName().replaceAll(".png", "");
            IncarnationScreen.renderWidthScaledText(name, guiGraphics, this.field_22793, this.field_22789 / 2 + 60, this.field_22790 / 2 + 40, Color.WHITE.getRGB(), 100);
            guiGraphics.method_51448().method_22909();
        }
        guiGraphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"Search"), (this.field_22789 - this.imageWidth) / 2 + 28, (this.field_22790 - this.imageHeight) / 2 + 20 + 15, Color.WHITE.getRGB());
        this.searchField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        int buttonOffset = 15;
        int cx = (this.field_22789 - this.imageWidth) / 2;
        int cy = (this.field_22790 - this.imageHeight) / 2;
        int btnW = 55;
        int btnH = 18;
        position = 0;
        skins = SkinRetriever.listAllSkins(PlayerUtil.SkinType.EITHER);
        IncarnationScreen.checkForMissingSkins();
        this.method_37063((class_364)new class_344(4, 4, 20, 18, 0, 0, 19, ColorScreen.PREFERENCES_BUTTON_LOCATION, button -> class_310.method_1551().method_1507(null)));
        this.searchField = new class_342(this.field_22793, cx + 10, cy + 30 + buttonOffset, cx - 15, 20, this.searchField, (class_2561)class_2561.method_43471((String)"skins.search"));
        this.searchField.method_1880(128);
        this.searchField.method_25365(true);
        this.searchField.method_1863(s -> {
            position = 0;
            skins.removeIf(file -> !file.getName().toLowerCase().contains(s.toLowerCase()));
            if (skins.isEmpty() || this.searchField.method_1882().isEmpty()) {
                skins = SkinRetriever.listAllSkins(currentSkinType);
            }
            this.stripTrending();
            IncarnationScreen.updateModels();
        });
        this.method_48265((class_364)this.searchField);
        this.method_25429((class_364)this.searchField);
        class_4185 btnPrevious = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.regen.previous"), button -> {
            if (this.searchField.method_1882().isEmpty()) {
                skins = SkinRetriever.listAllSkins(currentSkinType);
            }
            this.stripTrending();
            position = position >= skins.size() - 1 ? 0 : ++position;
            IncarnationScreen.updateModels();
        }).method_46434(cx + 140, cy + 60, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"button_tooltip.regen.previous_skin"))).method_46431();
        class_4185 btnNext = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.regen.next"), button -> {
            if (this.searchField.method_1882().isEmpty()) {
                skins = SkinRetriever.listAllSkins(currentSkinType);
            }
            this.stripTrending();
            position = position > 0 ? --position : skins.size() - 1;
            IncarnationScreen.updateModels();
        }).method_46434(cx + 215, cy + 60, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"button_tooltip.regen.next_skin"))).method_46431();
        class_4185 btnBack = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.regen.back"), button -> class_310.method_1551().method_1507((class_437)new PreferencesScreen())).method_46434(cx + 10, cy + 115 - buttonOffset, 55, 20).method_46431();
        class_4185 btnOpenFolder = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.regen.open_folder"), button -> class_156.method_668().method_672(SkinRetriever.SKINS_DIR)).method_46434(cx + 90 - 20, cy + 115 - buttonOffset, 55, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"button_tooltip.regen.open_folder"))).method_46431();
        class_4185 btnSave = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.regen.save"), button -> {
            IncarnationScreen.updateModels();
            new NextSkinMessage(RegenUtil.fileToBytes(skins.get(position)), isAlex).send();
        }).method_46434(cx + 90 - 20, cy + 90 - buttonOffset, 55, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"button_tooltip.regen.save_skin"))).method_46431();
        class_4185 btnResetSkin = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.regen.reset_skin"), button -> VisualManipulator.sendResetMessage()).method_46434(cx + 10, cy + 90 - buttonOffset, 55, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"button_tooltip.regen.reset_mojang"))).method_46431();
        this.excludeTrending = new RCheckbox(cx + 10, cy + 145, 150, 20, (class_2561)class_2561.method_43471((String)"Include Web Skins?"), true, checkboxButton -> {
            if (checkboxButton instanceof class_4286) {
                class_4286 check = (class_4286)checkboxButton;
                position = 0;
                this.searchField.method_1852("");
                if (!check.method_20372()) {
                    skins.removeIf(file -> file.getAbsolutePath().contains("web"));
                } else {
                    skins = SkinRetriever.listAllSkins(currentSkinType);
                }
                IncarnationScreen.updateModels();
            }
        });
        this.method_37063((class_364)this.excludeTrending);
        this.method_37063((class_364)btnNext);
        this.method_37063((class_364)btnPrevious);
        this.method_37063((class_364)btnOpenFolder);
        this.method_37063((class_364)btnBack);
        this.method_37063((class_364)btnSave);
        this.method_37063((class_364)btnResetSkin);
        RegenerationData.get((class_1309)this.field_22787.field_1724).ifPresent(data -> {
            currentSkinType = data.preferredModel();
        });
        RegenerationData.get((class_1309)class_310.method_1551().field_1724).ifPresent(data -> {
            currentSkinType = data.preferredModel();
        });
        IncarnationScreen.updateModels();
        this.excludeTrending.field_22763 = true;
    }

    static {
        renderChoice = currentSkinType = ((RegenerationData)RegenerationData.get((class_1309)Objects.requireNonNull(class_310.method_1551().field_1724)).orElse(null)).preferredModel();
        skins = null;
        position = 0;
    }
}

