/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.client.animation;

import java.util.concurrent.atomic.AtomicBoolean;
import mc.craig.software.regen.common.objects.RItems;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.common.regen.transitions.TransitionType;
import mc.craig.software.regen.common.regen.transitions.TransitionTypeRenderers;
import mc.craig.software.regen.util.PlayerUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1792;
import net.minecraft.class_572;
import net.minecraft.class_591;

public class AnimationHandler {
    public static class_1792[] LEG_ITEMS = new class_1792[]{RItems.F_ROBES_LEGS.get(), RItems.M_ROBES_LEGS.get(), RItems.GUARD_LEGS.get(), RItems.ROBES_FEET.get()};
    public static class_1792[] BODY_ITEMS = new class_1792[]{RItems.F_ROBES_CHEST.get(), RItems.GUARD_CHEST.get(), RItems.M_ROBES_CHEST.get()};

    public static void setRotationAnglesCallback(class_572<?> bipedModel, class_1309 livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        RegenerationData.get(livingEntity).ifPresent(iRegen -> {
            TransitionType type = iRegen.transitionType();
            TransitionTypeRenderers.get(type).animate(bipedModel, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (iRegen.regenState() != RegenStates.REGENERATING && livingEntity.method_5864() == class_1299.field_6097) {
                AnimationHandler.handleArmor(bipedModel, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
            if (livingEntity.method_5864() == class_1299.field_6097 && PlayerUtil.isPlayerAboveZeroGrid(livingEntity) && iRegen.regenState() == RegenStates.POST) {
                bipedModel.field_3398.field_3654 = (float)Math.toRadians(20.0);
                bipedModel.field_3398.field_3675 = (float)Math.toRadians(0.0);
                bipedModel.field_3398.field_3674 = (float)Math.toRadians(0.0);
                bipedModel.field_3397.field_3674 = (float)Math.toRadians(-2.0);
                bipedModel.field_3392.field_3674 = (float)Math.toRadians(2.0);
            }
        });
        AnimationHandler.correctPlayerModel(bipedModel);
    }

    public static void handleArmor(class_572 bipedModel, class_1309 livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (bipedModel instanceof class_591) {
            class_591 playerModel = (class_591)bipedModel;
            playerModel.field_3483.field_3665 = AnimationHandler.hideModelPartIf(livingEntity, BODY_ITEMS, class_1664.field_7564, class_1304.field_6174);
            playerModel.field_3486.field_3665 = livingEntity.method_6118(class_1304.field_6174).method_7909() != RItems.GUARD_CHEST.get();
            playerModel.field_3484.field_3665 = playerModel.field_3486.field_3665;
            playerModel.field_3482.field_3665 = AnimationHandler.hideModelPartIf(livingEntity, LEG_ITEMS, class_1664.field_7566, class_1304.field_6172);
            playerModel.field_3479.field_3665 = AnimationHandler.hideModelPartIf(livingEntity, LEG_ITEMS, class_1664.field_7565, class_1304.field_6172);
        }
    }

    public static boolean showArms(class_1309 livingEntity) {
        AtomicBoolean show = new AtomicBoolean(true);
        RegenerationData.get(livingEntity).ifPresent(iRegen -> show.set(iRegen.handState() != IRegen.Hand.NOT_CUT));
        return !show.get();
    }

    public static void correctPlayerModel(class_572 bipedModel) {
        if (bipedModel instanceof class_591) {
            class_591 playerModel = (class_591)bipedModel;
            playerModel.field_3394.method_17138(playerModel.field_3398);
            playerModel.field_3484.method_17138(playerModel.field_27433);
            playerModel.field_3486.method_17138(playerModel.field_3401);
            playerModel.field_3482.method_17138(playerModel.field_3397);
            playerModel.field_3479.method_17138(playerModel.field_3392);
        }
    }

    public static boolean hideModelPartIf(class_1309 livingEntity, class_1792[] items, class_1664 playerModelPart, class_1304 equipmentSlot) {
        for (class_1792 item : items) {
            if (item != livingEntity.method_6118(equipmentSlot).method_7909()) continue;
            return false;
        }
        return true;
    }

    public static interface Animation {
        public void animate(class_572<?> var1, class_1309 var2, float var3, float var4, float var5, float var6, float var7);
    }
}

