/*
 * Decompiled with CFR 0.152.
 */
package fr.adrien1106.reframed.client.model;

import fr.adrien1106.reframed.block.ReFramedBlock;
import fr.adrien1106.reframed.block.ReFramedEntity;
import fr.adrien1106.reframed.client.ReFramedClient;
import fr.adrien1106.reframed.client.model.apperance.CamoAppearance;
import fr.adrien1106.reframed.client.model.apperance.CamoAppearanceManager;
import fr.adrien1106.reframed.client.model.apperance.WeightedComputedAppearance;
import fr.adrien1106.reframed.mixin.MinecraftAccessor;
import fr.adrien1106.reframed.util.blocks.ThemeableBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_5819;

public abstract class RetexturingBakedModel
extends ForwardingBakedModel {
    protected final CamoAppearanceManager appearance_manager;
    protected final int theme_index;
    protected final boolean uv_lock;
    protected final boolean ao;
    protected final class_2680 item_state;
    protected final Object2ObjectLinkedOpenHashMap<MeshCacheKey, Mesh> RETEXTURED_MESH_CACHE = new Object2ObjectLinkedOpenHashMap<MeshCacheKey, Mesh>(128, 0.25f){

        protected void rehash(int v) {
        }
    };
    protected final Object2ObjectLinkedOpenHashMap<Object, Mesh> BASE_MESH_CACHE;
    protected static final class_2350[] DIRECTIONS_AND_NULL;

    public RetexturingBakedModel(class_1087 base_model, CamoAppearanceManager tam, int theme_index, class_3665 settings, class_2680 item_state, boolean ao) {
        this.wrapped = base_model;
        this.appearance_manager = tam;
        this.theme_index = theme_index;
        this.uv_lock = settings.method_3512();
        this.item_state = item_state;
        this.ao = ao;
        int cache_size = 64;
        class_2248 class_22482 = item_state.method_26204();
        if (class_22482 instanceof ReFramedBlock) {
            ReFramedBlock frame_block = (ReFramedBlock)class_22482;
            cache_size = frame_block.getModelStateCount() + 1;
        }
        this.BASE_MESH_CACHE = new Object2ObjectLinkedOpenHashMap<Object, Mesh>(cache_size, 0.25f){

            protected void rehash(int v) {
            }
        };
    }

    protected Mesh getBaseMesh(Object key, class_2680 state) {
        if (this.BASE_MESH_CACHE.containsKey(key)) {
            return (Mesh)this.BASE_MESH_CACHE.getAndMoveToFirst(key);
        }
        Mesh mesh = this.convertModel(state);
        this.BASE_MESH_CACHE.putAndMoveToFirst(key, (Object)mesh);
        return mesh;
    }

    protected abstract Mesh convertModel(class_2680 var1);

    public boolean isVanillaAdapter() {
        return false;
    }

    public class_1058 method_4711() {
        return this.appearance_manager.getDefaultAppearance(this.theme_index).getSprites(class_2350.field_11036, 0).get(0).sprite();
    }

    public void emitBlockQuads(class_1920 world, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2680 class_26802;
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ReFramedBlock)) {
            return;
        }
        ReFramedBlock frame_block = (ReFramedBlock)class_22482;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ThemeableBlockEntity) {
            ThemeableBlockEntity s = (ThemeableBlockEntity)class_25862;
            class_26802 = s.getTheme(this.theme_index);
        } else {
            class_26802 = null;
        }
        class_2680 theme = class_26802;
        QuadEmitter quad_emitter = context.getEmitter();
        if (theme == null || theme.method_26215()) {
            this.getRetexturedMesh(new MeshCacheKey(frame_block.getModelCacheKey(state), this.appearance_manager.getDefaultAppearance(this.theme_index), 0), state).outputTo(quad_emitter);
            return;
        }
        if (theme.method_26204() == class_2246.field_10499) {
            return;
        }
        CamoAppearance camo = this.appearance_manager.getCamoAppearance(world, theme, pos, this.theme_index, false);
        long seed = theme.method_26190(pos);
        int model_id = 0;
        if (camo instanceof WeightedComputedAppearance) {
            WeightedComputedAppearance wca = (WeightedComputedAppearance)camo;
            model_id = wca.getAppearanceIndex(seed);
        }
        int tint = 0xFF000000 | class_310.method_1551().method_1505().method_1697(theme, world, pos, 0);
        Mesh untintedMesh = this.getRetexturedMesh(new MeshCacheKey(frame_block.getModelCacheKey(state), camo, model_id), state);
        if (tint == -1) {
            untintedMesh.outputTo(quad_emitter);
        } else {
            context.pushTransform((RenderContext.QuadTransform)new TintingTransformer(camo, model_id, tint));
            untintedMesh.outputTo(quad_emitter);
            context.popTransform();
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        int tint;
        CamoAppearance appearance;
        class_2680 theme = ReFramedEntity.readStateFromItem(stack, this.theme_index);
        if (!theme.method_26215()) {
            appearance = this.appearance_manager.getCamoAppearance(null, theme, null, this.theme_index, true);
            tint = 0xFF000000 | ((MinecraftAccessor)class_310.method_1551()).getItemColors().method_1704(new class_1799((class_1935)theme.method_26204()), 0);
        } else {
            appearance = this.appearance_manager.getDefaultAppearance(this.theme_index);
            tint = -1;
        }
        Mesh untintedMesh = this.getRetexturedMesh(new MeshCacheKey("I", appearance, 0), this.item_state);
        QuadEmitter quad_emitter = context.getEmitter();
        if (tint == -1) {
            untintedMesh.outputTo(quad_emitter);
        } else {
            context.pushTransform((RenderContext.QuadTransform)new TintingTransformer(appearance, 0, tint));
            untintedMesh.outputTo(quad_emitter);
            context.popTransform();
        }
    }

    protected Mesh getRetexturedMesh(MeshCacheKey key, class_2680 state) {
        if (this.RETEXTURED_MESH_CACHE.containsKey((Object)key)) {
            return (Mesh)this.RETEXTURED_MESH_CACHE.getAndMoveToFirst((Object)key);
        }
        Mesh mesh = this.transformMesh(key, state);
        this.RETEXTURED_MESH_CACHE.putAndMoveToFirst((Object)key, (Object)mesh);
        return mesh;
    }

    protected Mesh transformMesh(MeshCacheKey key, class_2680 state) {
        MeshBuilder builder = ReFramedClient.HELPER.getFabricRenderer().meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        AtomicInteger quad_index = new AtomicInteger();
        this.getBaseMesh(key.state_key, state).forEach(quad -> {
            int i = -1;
            do {
                emitter.copyFrom(quad);
            } while ((i = key.appearance.transformQuad(emitter, i, quad_index.get(), key.model_id, this.ao, this.uv_lock)) > 0);
            if (quad.cullFace() == null) {
                quad_index.getAndIncrement();
            }
        });
        return builder.build();
    }

    static {
        class_2350[] values = class_2350.values();
        DIRECTIONS_AND_NULL = new class_2350[values.length + 1];
        System.arraycopy(values, 0, DIRECTIONS_AND_NULL, 0, values.length);
    }

    protected record MeshCacheKey(Object state_key, CamoAppearance appearance, int model_id) {
    }

    protected static class TintingTransformer
    implements RenderContext.QuadTransform {
        private final CamoAppearance appearance;
        private final int model_id;
        private final int tint;

        protected TintingTransformer(CamoAppearance appearance, int model_id, int tint) {
            this.appearance = appearance;
            this.model_id = model_id;
            this.tint = tint;
        }

        public boolean transform(MutableQuadView quad) {
            int camo_quad_index = quad.tag() - (quad.tag() >>> 8 << 8);
            if (camo_quad_index == 0) {
                return true;
            }
            if (this.appearance.hasColor(quad.nominalFace(), this.model_id, camo_quad_index)) {
                quad.color(this.tint, this.tint, this.tint, this.tint);
            }
            return true;
        }
    }
}

