/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.container.AlternativesContainer;
import com.refinedmods.refinedstorage.render.FluidRenderer;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import com.refinedmods.refinedstorage.tile.grid.GridTile;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class AlternativesScreen
extends BaseScreen<AlternativesContainer> {
    private static final int VISIBLE_ROWS = 5;
    private final Screen parent;
    private final ScrollbarWidget scrollbar;
    private final List<Line> lines = new ArrayList<Line>();
    private int type;
    private int slot;
    private ItemStack item;
    private FluidStack fluid;

    private AlternativesScreen(Screen parent, PlayerEntity player, ITextComponent title) {
        super(new AlternativesContainer(player), 175, 143, null, title);
        this.parent = parent;
        this.scrollbar = new ScrollbarWidget(this, 155, 20, 12, 89);
    }

    public AlternativesScreen(Screen parent, PlayerEntity player, ITextComponent title, ItemStack item, int slot) {
        this(parent, player, title);
        this.type = 0;
        this.slot = slot;
        this.item = item;
        this.fluid = null;
    }

    public AlternativesScreen(Screen parent, PlayerEntity player, ITextComponent title, FluidStack fluid, int slot) {
        this(parent, player, title);
        this.type = 1;
        this.slot = slot;
        this.item = null;
        this.fluid = fluid;
    }

    @Override
    public void onPostInit(int x, int y) {
        Line line;
        this.lines.clear();
        if (this.item != null) {
            this.lines.add(new ItemLine(this.item));
            for (ResourceLocation owningTag : ItemTags.func_199903_a().func_199913_a((Object)this.item.func_77973_b())) {
                this.lines.add(new TagLine(owningTag, GridTile.ALLOWED_ITEM_TAGS.getValue().get(this.slot).contains(owningTag)));
                int itemCount = 0;
                line = new ItemListLine();
                for (Item itemInTag : ItemTags.func_199903_a().func_199910_a(owningTag).func_230236_b_()) {
                    if (itemCount > 0 && itemCount % 8 == 0) {
                        this.lines.add(line);
                        line = new ItemListLine();
                    }
                    ++itemCount;
                    ((ItemListLine)line).addItem(new ItemStack((IItemProvider)itemInTag));
                }
                this.lines.add(line);
            }
        } else if (this.fluid != null) {
            this.lines.add(new FluidLine(this.fluid));
            for (ResourceLocation owningTag : FluidTags.func_226157_a_().func_199913_a((Object)this.fluid.getFluid())) {
                this.lines.add(new TagLine(owningTag, GridTile.ALLOWED_FLUID_TAGS.getValue().get(this.slot).contains(owningTag)));
                int fluidCount = 0;
                line = new FluidListLine();
                for (Fluid fluidInTag : FluidTags.func_226157_a_().func_199910_a(owningTag).func_230236_b_()) {
                    if (fluidCount > 0 && fluidCount % 8 == 0) {
                        this.lines.add(line);
                        line = new FluidListLine();
                    }
                    ++fluidCount;
                    ((FluidListLine)line).addFluid(new FluidStack(fluidInTag, 1000));
                }
                this.lines.add(line);
            }
        }
        int xx = 8;
        int yy = 20;
        for (int i = 0; i < this.lines.size(); ++i) {
            boolean visible;
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + 5;
            if (!visible) continue;
            this.lines.get(i).layoutDependantControls(true, this.field_147003_i + xx + 3, this.field_147009_r + yy + 3);
            yy += 18;
        }
        Button apply = this.addButton(x + 7, y + 114, 50, 20, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.alternatives.apply"), this.lines.size() > 1, true, btn -> this.apply());
        this.addButton(x + apply.func_230998_h_() + 7 + 4, y + 114, 50, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), true, true, btn -> this.close());
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 5);
        this.scrollbar.setMaxOffset(this.getRows() - 5);
    }

    private int getRows() {
        return this.lines.size();
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/alternatives.png");
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.scrollbar.render(matrixStack);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        boolean visible;
        int i;
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        int x = 8;
        int y = 20;
        for (i = 0; i < this.lines.size(); ++i) {
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + 5;
            if (visible) {
                this.lines.get(i).layoutDependantControls(true, this.field_147003_i + x + 3, this.field_147009_r + y + 3);
                this.lines.get(i).render(matrixStack, x, y);
                y += 18;
                continue;
            }
            this.lines.get(i).layoutDependantControls(false, -100, -100);
        }
        x = 8;
        y = 20;
        for (i = 0; i < this.lines.size(); ++i) {
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + 5;
            if (!visible) continue;
            this.lines.get(i).renderTooltip(matrixStack, x, y, mouseX, mouseY);
            y += 18;
        }
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        super.func_212927_b(mx, my);
    }

    public boolean func_231044_a_(double mx, double my, int button) {
        return this.scrollbar.func_231044_a_(mx, my, button) || super.func_231044_a_(mx, my, button);
    }

    public boolean func_231048_c_(double mx, double my, int button) {
        return this.scrollbar.func_231048_c_(mx, my, button) || super.func_231048_c_(mx, my, button);
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        return this.scrollbar.func_231043_a_(x, y, delta) || super.func_231043_a_(x, y, delta);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.close();
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    private void close() {
        this.field_230706_i_.func_147108_a(this.parent);
    }

    private void apply() {
        List<Set<ResourceLocation>> existing;
        HashSet<ResourceLocation> allowed = new HashSet<ResourceLocation>();
        for (Line line : this.lines) {
            TagLine tagLine;
            if (!(line instanceof TagLine) || !(tagLine = (TagLine)line).widget.func_212942_a()) continue;
            allowed.add(tagLine.tagName);
        }
        if (this.type == 0) {
            existing = GridTile.ALLOWED_ITEM_TAGS.getValue();
            existing.set(this.slot, allowed);
            TileDataManager.setParameter(GridTile.ALLOWED_ITEM_TAGS, existing);
        } else if (this.type == 1) {
            existing = GridTile.ALLOWED_FLUID_TAGS.getValue();
            existing.set(this.slot, allowed);
            TileDataManager.setParameter(GridTile.ALLOWED_FLUID_TAGS, existing);
        }
        this.close();
    }

    private class FluidListLine
    implements Line {
        private final List<FluidStack> fluids = new ArrayList<FluidStack>();

        private FluidListLine() {
        }

        public void addFluid(FluidStack stack) {
            this.fluids.add(stack);
        }

        @Override
        public void render(MatrixStack matrixStack, int x, int y) {
            for (FluidStack fluidInList : this.fluids) {
                FluidRenderer.INSTANCE.render(matrixStack, x + 3, y, fluidInList);
                x += 17;
            }
        }

        @Override
        public void renderTooltip(MatrixStack matrixStack, int x, int y, int mx, int my) {
            for (FluidStack fluidInList : this.fluids) {
                if (RenderUtils.inBounds(x + 3, y, 16, 16, mx, my)) {
                    AlternativesScreen.this.renderTooltip(matrixStack, mx, my, fluidInList.getDisplayName().getString());
                }
                x += 17;
            }
        }
    }

    private class ItemListLine
    implements Line {
        private final List<ItemStack> items = new ArrayList<ItemStack>();

        private ItemListLine() {
        }

        public void addItem(ItemStack stack) {
            this.items.add(stack);
        }

        @Override
        public void render(MatrixStack matrixStack, int x, int y) {
            for (ItemStack itemInList : this.items) {
                AlternativesScreen.this.renderItem(matrixStack, x + 3, y, itemInList);
                x += 17;
            }
        }

        @Override
        public void renderTooltip(MatrixStack matrixStack, int x, int y, int mx, int my) {
            for (ItemStack itemInList : this.items) {
                if (RenderUtils.inBounds(x + 3, y, 16, 16, mx, my)) {
                    AlternativesScreen.this.renderTooltip(matrixStack, itemInList, mx, my, RenderUtils.getTooltipFromItem(itemInList));
                }
                x += 17;
            }
        }
    }

    private class TagLine
    implements Line {
        private final ResourceLocation tagName;
        private final CheckboxWidget widget;

        public TagLine(ResourceLocation tagName, boolean checked) {
            this.tagName = tagName;
            this.widget = AlternativesScreen.this.addCheckBox(-100, -100, (ITextComponent)new StringTextComponent(RenderUtils.shorten(tagName.toString(), 22)), checked, btn -> {});
            this.widget.setFGColor(-13158601);
            this.widget.setShadow(false);
        }

        @Override
        public void layoutDependantControls(boolean visible, int x, int y) {
            this.widget.field_230694_p_ = visible;
            this.widget.field_230690_l_ = x;
            this.widget.field_230691_m_ = y;
        }
    }

    private class FluidLine
    implements Line {
        private final FluidStack fluid;

        public FluidLine(FluidStack item) {
            this.fluid = item;
        }

        @Override
        public void render(MatrixStack matrixStack, int x, int y) {
            FluidRenderer.INSTANCE.render(matrixStack, x + 3, y + 2, this.fluid);
            AlternativesScreen.this.renderString(matrixStack, x + 4 + 19, y + 7, this.fluid.getDisplayName().getString());
        }
    }

    private class ItemLine
    implements Line {
        private final ItemStack item;

        public ItemLine(ItemStack item) {
            this.item = item;
        }

        @Override
        public void render(MatrixStack matrixStack, int x, int y) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AlternativesScreen.this.renderItem(matrixStack, x + 3, y + 2, this.item);
            AlternativesScreen.this.renderString(matrixStack, x + 4 + 19, y + 7, this.item.func_200301_q().getString());
        }
    }

    private static interface Line {
        default public void render(MatrixStack matrixStack, int x, int y) {
        }

        default public void renderTooltip(MatrixStack matrixStack, int x, int y, int mx, int my) {
        }

        default public void layoutDependantControls(boolean visible, int x, int y) {
        }
    }
}

