/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container.slot.filter;

import com.refinedmods.refinedstorage.container.slot.BaseSlot;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.util.StackUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class FluidFilterSlot
extends BaseSlot {
    public static final int FILTER_ALLOW_SIZE = 1;
    public static final int FILTER_ALLOW_ALTERNATIVES = 2;
    private final int flags;
    private final FluidInventory fluidInventory;

    public FluidFilterSlot(FluidInventory inventory, int inventoryIndex, int x, int y, int flags) {
        super((IItemHandler)new ItemStackHandler(inventory.getSlots()), inventoryIndex, x, y);
        this.flags = flags;
        this.fluidInventory = inventory;
    }

    public FluidFilterSlot(FluidInventory inventory, int inventoryIndex, int x, int y) {
        this(inventory, inventoryIndex, x, y, 0);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return false;
    }

    public void onContainerClicked(@Nonnull ItemStack stack) {
        this.fluidInventory.setFluid(this.getSlotIndex(), (FluidStack)StackUtils.getFluid(stack, true).getValue());
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        return false;
    }

    public boolean isSizeAllowed() {
        return (this.flags & 1) == 1;
    }

    public boolean isAlternativesAllowed() {
        return (this.flags & 2) == 2;
    }

    public FluidInventory getFluidInventory() {
        return this.fluidInventory;
    }

    public boolean hasStack() {
        return !this.fluidInventory.getFluid(this.getSlotIndex()).isEmpty();
    }
}

