/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.externalstorage;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.storage.externalstorage.ItemExternalStorageCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemExternalStorage
implements IExternalStorage<ItemStack> {
    private final IExternalStorageContext context;
    private final Supplier<IItemHandler> handlerSupplier;
    private final boolean connectedToInterface;
    private final ItemExternalStorageCache cache = new ItemExternalStorageCache();

    public ItemExternalStorage(IExternalStorageContext context, Supplier<IItemHandler> handlerSupplier, boolean connectedToInterface) {
        this.context = context;
        this.handlerSupplier = handlerSupplier;
        this.connectedToInterface = connectedToInterface;
    }

    public boolean isConnectedToInterface() {
        return this.connectedToInterface;
    }

    @Override
    public void update(INetwork network) {
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        this.cache.update(network, this.handlerSupplier.get());
    }

    @Override
    public long getCapacity() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return 0L;
        }
        long capacity = 0L;
        for (int i = 0; i < handler.getSlots(); ++i) {
            capacity += (long)handler.getSlotLimit(i);
        }
        return capacity;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacks.add(handler.getStackInSlot(i));
        }
        return stacks;
    }

    @Override
    @Nonnull
    public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
        if (stack.func_190926_b()) {
            return stack;
        }
        IItemHandler handler = this.handlerSupplier.get();
        if (handler != null && this.context.acceptsItem(stack)) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), (action == Action.SIMULATE ? 1 : 0) != 0);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    @Nonnull
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
        if (stack.func_190926_b()) {
            return stack;
        }
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        int remaining = size;
        ItemStack received = ItemStack.field_190927_a;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack got;
            ItemStack slot = handler.getStackInSlot(i);
            if (slot.func_190926_b() || !API.instance().getComparer().isEqual(slot, stack, flags) || (got = handler.extractItem(i, remaining, action == Action.SIMULATE)).func_190926_b()) continue;
            if (received.func_190926_b()) {
                received = got.func_77946_l();
            } else {
                received.func_190917_f(got.func_190916_E());
            }
            if ((remaining -= got.func_190916_E()) == 0) break;
        }
        return received;
    }

    @Override
    public int getStored() {
        return this.cache.getStored();
    }

    @Override
    public int getPriority() {
        return this.context.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.func_190916_E();
    }
}

