/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewResponseMessage;
import com.refinedmods.refinedstorage.network.grid.GridCraftingStartResponseMessage;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidGridHandler
implements IFluidGridHandler {
    private final INetwork network;

    public FluidGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(ServerPlayerEntity player, UUID id, boolean shift) {
        FluidStack stack = this.network.getFluidStorageCache().getList().get(id);
        if (stack == null || stack.getAmount() < 1000 || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (PlayerEntity)player) || !this.network.canRun()) {
            return;
        }
        NetworkUtils.extractBucketFromPlayerInventoryOrNetwork((PlayerEntity)player, this.network, bucket -> bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(fluidHandler -> {
            this.network.getFluidStorageTracker().changed((PlayerEntity)player, stack.copy());
            FluidStack extracted = this.network.extractFluid(stack, 1000, Action.PERFORM);
            fluidHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
            if (shift) {
                if (!player.field_71071_by.func_70441_a(fluidHandler.getContainer().func_77946_l())) {
                    InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)fluidHandler.getContainer());
                }
            } else {
                player.field_71071_by.func_70437_b(fluidHandler.getContainer());
                player.func_71113_k();
            }
            this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessFluidGrid().getExtractUsage());
        }));
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayerEntity player, ItemStack container) {
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (PlayerEntity)player) || !this.network.canRun()) {
            return container;
        }
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(container, true);
        if (!((FluidStack)result.getValue()).isEmpty() && this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.SIMULATE).isEmpty()) {
            this.network.getFluidStorageTracker().changed((PlayerEntity)player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(container, false);
            this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.PERFORM);
            this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessFluidGrid().getInsertUsage());
            return (ItemStack)result.getLeft();
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(ServerPlayerEntity player) {
        player.field_71071_by.func_70437_b(this.onInsert(player, player.field_71071_by.func_70445_o()));
        player.func_71113_k();
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayerEntity player, UUID id, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getCraftablesList().get(id);
        if (stack != null) {
            ICalculationResult result = this.network.getCraftingManager().create(stack, quantity);
            if (result == null) {
                return;
            }
            if (!result.isOk() && result.getType() != CalculationResultType.MISSING) {
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(Collections.singletonList(new ErrorCraftingPreviewElement(result.getType(), result.getRecursedPattern() == null ? ItemStack.field_190927_a : result.getRecursedPattern().getStack())), id, quantity, true));
            } else if (result.isOk() && noPreview) {
                this.network.getCraftingManager().start(result.getTask());
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingStartResponseMessage());
            } else {
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(result.getPreviewElements(), id, quantity, true));
            }
        }
    }

    @Override
    public void onCraftingRequested(ServerPlayerEntity player, UUID id, int quantity) {
        ICalculationResult result;
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getCraftablesList().get(id);
        if (stack != null && (result = this.network.getCraftingManager().create(stack, quantity)).isOk()) {
            this.network.getCraftingManager().start(result.getTask());
        }
    }
}

