/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor.ErrorCraftingMonitorElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class CraftingMonitorElementList
implements ICraftingMonitorElementList {
    private final List<ICraftingMonitorElement> elements = new LinkedList<ICraftingMonitorElement>();
    private final Map<ResourceLocation, Map<Integer, ICraftingMonitorElement>> currentLists = new LinkedHashMap<ResourceLocation, Map<Integer, ICraftingMonitorElement>>();
    private final Map<ResourceLocation, Map<Integer, ICraftingMonitorElement>> currentCraftingLists = new LinkedHashMap<ResourceLocation, Map<Integer, ICraftingMonitorElement>>();
    private final Map<ResourceLocation, Map<Integer, ICraftingMonitorElement>> currentProcessingLists = new LinkedHashMap<ResourceLocation, Map<Integer, ICraftingMonitorElement>>();
    private final Map<ResourceLocation, Map<Integer, ICraftingMonitorElement>> currentStorageLists = new LinkedHashMap<ResourceLocation, Map<Integer, ICraftingMonitorElement>>();

    @Override
    public void directAdd(ICraftingMonitorElement element) {
        this.elements.add(element);
    }

    @Override
    public void addStorage(ICraftingMonitorElement element) {
        ICraftingMonitorElement existingElement;
        Map<Integer, ICraftingMonitorElement> craftingElements = this.currentCraftingLists.get(element.getBaseId());
        Map<Integer, ICraftingMonitorElement> processingElements = this.currentProcessingLists.get(element.getBaseId());
        Map<Integer, ICraftingMonitorElement> storedElements = this.currentStorageLists.get(element.getBaseId());
        boolean merged = false;
        if (craftingElements != null && (existingElement = craftingElements.get(element.baseElementHashCode())) != null) {
            if (existingElement instanceof ErrorCraftingMonitorElement) {
                ((ErrorCraftingMonitorElement)existingElement).mergeBases(element);
            } else {
                existingElement.merge(element);
            }
            merged = true;
        }
        if (processingElements != null && (existingElement = processingElements.get(element.baseElementHashCode())) != null) {
            if (existingElement instanceof ErrorCraftingMonitorElement) {
                ((ErrorCraftingMonitorElement)existingElement).mergeBases(element);
            } else {
                existingElement.merge(element);
            }
            merged = true;
        }
        if (!merged) {
            if (storedElements == null) {
                storedElements = new HashMap<Integer, ICraftingMonitorElement>();
            }
            storedElements.put(element.baseElementHashCode(), element);
            this.currentStorageLists.put(element.getBaseId(), storedElements);
        }
    }

    @Override
    public void add(ICraftingMonitorElement element, boolean isProcessing) {
        ICraftingMonitorElement existingElement;
        Map<Integer, ICraftingMonitorElement> currentElements;
        Map<Integer, ICraftingMonitorElement> map = currentElements = isProcessing ? this.currentProcessingLists.get(element.getBaseId()) : this.currentCraftingLists.get(element.getBaseId());
        if (currentElements == null) {
            currentElements = new LinkedHashMap<Integer, ICraftingMonitorElement>();
        }
        if ((existingElement = currentElements.get(element.baseElementHashCode())) == null) {
            existingElement = element;
        } else {
            existingElement.merge(element);
        }
        currentElements.put(existingElement.baseElementHashCode(), existingElement);
        if (isProcessing) {
            this.currentProcessingLists.put(existingElement.getBaseId(), currentElements);
        } else {
            this.currentCraftingLists.put(existingElement.getBaseId(), currentElements);
        }
    }

    @Override
    public void add(ICraftingMonitorElement element) {
        ICraftingMonitorElement exitingElement;
        Map<Integer, ICraftingMonitorElement> currentElements = this.currentLists.get(element.getId());
        if (currentElements == null) {
            currentElements = new HashMap<Integer, ICraftingMonitorElement>();
        }
        if ((exitingElement = currentElements.get(element.elementHashCode())) == null) {
            exitingElement = element;
        } else {
            exitingElement.merge(element);
        }
        currentElements.put(exitingElement.elementHashCode(), exitingElement);
        this.currentLists.put(exitingElement.getId(), currentElements);
    }

    @Override
    public void commit() {
        this.currentLists.values().stream().map(Map::values).flatMap(Collection::stream).forEach(this.elements::add);
        this.currentLists.clear();
        this.currentCraftingLists.values().stream().map(Map::values).flatMap(Collection::stream).forEach(this.elements::add);
        this.currentCraftingLists.clear();
        this.currentProcessingLists.values().stream().map(Map::values).flatMap(Collection::stream).forEach(this.elements::add);
        this.currentProcessingLists.clear();
        this.currentStorageLists.values().stream().map(Map::values).flatMap(Collection::stream).forEach(this.elements::add);
        this.currentStorageLists.clear();
    }

    @Override
    public List<ICraftingMonitorElement> getElements() {
        if (!(this.currentLists.isEmpty() && this.currentCraftingLists.isEmpty() && this.currentProcessingLists.isEmpty() && this.currentStorageLists.isEmpty())) {
            this.commit();
        }
        return this.elements;
    }
}

