/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.util.Action;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.logging.log4j.LogManager;

public interface ICraftingPatternContainer {
    default public int getUpdateInterval() {
        return 10;
    }

    default public int getMaximumSuccessfulCraftingUpdates() {
        return 1;
    }

    @Nullable
    public IItemHandler getConnectedInventory();

    @Nullable
    public IFluidHandler getConnectedFluidInventory();

    @Nullable
    public TileEntity getConnectedTile();

    public TileEntity getFacingTile();

    public Direction getDirection();

    public List<ICraftingPattern> getPatterns();

    @Nullable
    public IItemHandlerModifiable getPatternInventory();

    public ITextComponent getName();

    public BlockPos getPosition();

    @Nullable
    public ICraftingPatternContainer getRootContainer();

    public UUID getUuid();

    default public boolean isLocked() {
        return false;
    }

    public void unlock();

    default public void onUsedForProcessing() {
    }

    default public boolean hasConnectedInventory() {
        return this.getConnectedInventory() != null;
    }

    default public boolean hasConnectedFluidInventory() {
        return this.getConnectedFluidInventory() != null;
    }

    default public boolean insertItemsIntoInventory(Collection<ItemStack> toInsert, Action action) {
        boolean success;
        IItemHandler dest = this.getConnectedInventory();
        if (toInsert.isEmpty()) {
            return true;
        }
        if (dest == null) {
            return false;
        }
        ArrayDeque<ItemStack> stacks = new ArrayDeque<ItemStack>(toInsert);
        ItemStack current = (ItemStack)stacks.poll();
        List availableSlots = IntStream.range(0, dest.getSlots()).boxed().collect(Collectors.toList());
        while (current != null && !availableSlots.isEmpty()) {
            ItemStack remainder = ItemStack.field_190927_a;
            for (int i = 0; i < availableSlots.size(); ++i) {
                int slot = (Integer)availableSlots.get(i);
                remainder = dest.insertItem(slot, current.func_77946_l(), action == Action.SIMULATE);
                if (!remainder.func_190926_b() && current.func_190916_E() == remainder.func_190916_E()) continue;
                availableSlots.remove(i);
                break;
            }
            if (remainder.func_190926_b()) {
                current = (ItemStack)stacks.poll();
                continue;
            }
            if (current.func_190916_E() == remainder.func_190916_E()) break;
            current = remainder;
        }
        boolean bl = success = current == null && stacks.isEmpty();
        if (!success && action == Action.PERFORM) {
            LogManager.getLogger().warn("Inventory unexpectedly didn't accept {}, the remainder has been voided!", (Object)(current != null ? current.func_77977_a() : null));
        }
        return success;
    }

    default public boolean insertFluidsIntoInventory(Collection<FluidStack> toInsert, Action action) {
        IFluidHandler dest = this.getConnectedFluidInventory();
        if (toInsert.isEmpty()) {
            return true;
        }
        if (dest == null) {
            return false;
        }
        for (FluidStack stack : toInsert) {
            int filled = dest.fill(stack, action == Action.SIMULATE ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            if (filled == stack.getAmount()) continue;
            if (action == Action.PERFORM) {
                LogManager.getLogger().warn("Inventory unexpectedly didn't accept all of {}, the remainder has been voided!", (Object)stack.getTranslationKey());
            }
            return false;
        }
        return true;
    }
}

