/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.serializer;

import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.ConfigData;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.annotation.Config;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.serializer.ConfigSerializer;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class PartitioningSerializer<T extends GlobalData, M extends ConfigData>
implements ConfigSerializer<T> {
    private Class<T> configClass;
    private Map<Field, ConfigSerializer<M>> serializers;

    private PartitioningSerializer(Config definition, Class<T> configClass, ConfigSerializer.Factory<M> factory) {
        this.configClass = configClass;
        this.serializers = PartitioningSerializer.getModuleFields(configClass).stream().collect(Utils.toLinkedMap(Function.identity(), field -> factory.create(PartitioningSerializer.createDefinition(String.format("%s/%s", definition.name(), field.getType().getAnnotation(Config.class).name())), field.getType())));
    }

    public static <T extends GlobalData, M extends ConfigData> ConfigSerializer.Factory<T> wrap(ConfigSerializer.Factory<M> inner) {
        return (definition, configClass) -> new PartitioningSerializer(definition, configClass, inner);
    }

    private static Config createDefinition(final String name) {
        return new Config(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Config.class;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public int hashCode() {
                return "name".hashCode() * 127 ^ this.name().hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof Config && ((Config)obj).name().equals(this.name());
            }
        };
    }

    private static boolean isValidModule(Field field) {
        return ConfigData.class.isAssignableFrom(field.getType()) && field.getType().isAnnotationPresent(Config.class);
    }

    private static List<Field> getModuleFields(Class<?> configClass) {
        return Arrays.stream(configClass.getDeclaredFields()).filter(PartitioningSerializer::isValidModule).collect(Collectors.toList());
    }

    @Override
    public void serialize(T config) throws ConfigSerializer.SerializationException {
        for (Map.Entry<Field, ConfigSerializer<M>> entry : this.serializers.entrySet()) {
            entry.getValue().serialize((ConfigData)Utils.getUnsafely(entry.getKey(), config));
        }
    }

    @Override
    public T deserialize() throws ConfigSerializer.SerializationException {
        ConfigData ret = this.createDefault();
        for (Map.Entry<Field, ConfigSerializer<M>> entry : this.serializers.entrySet()) {
            Utils.setUnsafely(entry.getKey(), ret, entry.getValue().deserialize());
        }
        return (T)ret;
    }

    @Override
    public T createDefault() {
        return (T)((GlobalData)Utils.constructUnsafely(this.configClass));
    }

    public static abstract class GlobalData
    implements ConfigData {
        public GlobalData() {
            Arrays.stream(this.getClass().getDeclaredFields()).filter(field -> !PartitioningSerializer.isValidModule(field)).forEach(field -> {
                throw new RuntimeException(String.format("Invalid module: %s", field));
            });
        }

        @Override
        public final void validatePostLoad() throws ConfigData.ValidationException {
            for (Field moduleField : PartitioningSerializer.getModuleFields(this.getClass())) {
                ((ConfigData)Utils.getUnsafely(moduleField, this)).validatePostLoad();
            }
        }
    }
}

