/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.shadowed.com.therandomlabs.autoconfigtoml;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.conversion.Converter;
import com.electronwill.nightconfig.core.conversion.ForceBreakdown;
import com.electronwill.nightconfig.core.conversion.InvalidValueException;
import com.electronwill.nightconfig.core.conversion.ObjectConverter;
import com.electronwill.nightconfig.core.conversion.SpecDoubleInRange;
import com.electronwill.nightconfig.core.conversion.SpecEnum;
import com.electronwill.nightconfig.core.conversion.SpecFloatInRange;
import com.electronwill.nightconfig.core.conversion.SpecIntInRange;
import com.electronwill.nightconfig.core.conversion.SpecLongInRange;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.CharacterOutput;
import com.electronwill.nightconfig.core.io.CharsWrapper;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.google.common.base.CaseFormat;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.AutoConfig;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.ConfigData;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.ConfigManager;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.annotation.ConfigEntry;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.serializer.ConfigSerializer;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TOMLConfigSerializer<T extends ConfigData>
implements ConfigSerializer<T> {
    private static final Logger logger = LogManager.getLogger();
    private static final ObjectConverter objectConverter = new ObjectConverter();
    private static final TomlWriter tomlWriter = new TomlWriter();
    private static final Method mustPreserve;
    private static final Method getConverter;
    private static final Method getPath;
    private static final Method checkField;
    private static final Method bottomElementType;
    private static final Method elementTypes;
    private static final Method write;
    private static final Method load;
    private final Class<T> configClass;
    private final CommentedFileConfig fileConfig;
    private @Nullable T config;

    public TOMLConfigSerializer(com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.annotation.Config definition, Class<T> configClass) {
        this.configClass = configClass;
        String path = configClass.isAnnotationPresent(com.electronwill.nightconfig.core.conversion.Path.class) ? configClass.getAnnotation(com.electronwill.nightconfig.core.conversion.Path.class).value() : definition.name() + ".toml";
        this.fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve(path)).sync().build();
    }

    @Override
    public void serialize(T config) {
        try {
            T defaultConfig = this.createDefault();
            this.moveToFileConfig(config, this.configClass, (CommentedConfig)this.fileConfig, defaultConfig);
            this.moveToObjectConfig((UnmodifiableConfig)this.fileConfig, config, this.configClass, defaultConfig);
            this.config = this.validateAndSave(config, defaultConfig);
        }
        catch (IOException | IllegalAccessException | RuntimeException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to serialize: " + this.configClass, ex);
        }
    }

    @Override
    public T deserialize() {
        if (!Files.exists(this.fileConfig.getNioPath(), new LinkOption[0])) {
            this.config = this.createDefault();
            return this.config;
        }
        try {
            File file = this.fileConfig.getFile();
            try (BOMInputStream stream = new BOMInputStream((InputStream)new FileInputStream(file));){
                if (stream.hasBOM()) {
                    FileUtils.write((File)file, (CharSequence)IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8);
                }
                this.fileConfig.load();
            }
            catch (ParsingException ex) {
                logger.error((Message)new ParameterizedMessage("Failed to deserialize: {}", this.configClass), (Throwable)ex);
                if (this.config == null) {
                    this.config = this.createDefault();
                }
                return this.config;
            }
            this.config = this.createDefault();
            T defaultConfig = this.createDefault();
            this.moveToObjectConfig((UnmodifiableConfig)this.fileConfig, this.config, this.configClass, defaultConfig);
            this.config = this.validateAndSave(this.config, defaultConfig);
            return this.config;
        }
        catch (IOException | IllegalAccessException | RuntimeException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to deserialize: " + this.configClass, ex);
        }
    }

    @Override
    public T createDefault() {
        return (T)((ConfigData)Utils.constructUnsafely(this.configClass));
    }

    public T getConfig() {
        return this.config == null ? this.deserialize() : this.config;
    }

    public void reloadFromDisk() {
        try {
            load.invoke(AutoConfig.getConfigHolder(this.configClass), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to reload from disk: " + this.configClass, ex);
        }
    }

    private T validateAndSave(T config, Object defaultConfig) throws IllegalAccessException, InvocationTargetException, IOException {
        config = this.validate(config);
        this.fileConfig.entrySet().clear();
        this.moveToFileConfig(config, this.configClass, (CommentedConfig)this.fileConfig, defaultConfig);
        this.fileConfig.save();
        String string = FileUtils.readFileToString((File)this.fileConfig.getFile(), (Charset)StandardCharsets.UTF_8).trim() + System.lineSeparator();
        if (this.configClass.isAnnotationPresent(Comment.class)) {
            String[] lines = this.configClass.getAnnotation(Comment.class).value();
            String comment = Arrays.stream(lines).map(line -> "# " + line).collect(Collectors.joining(System.lineSeparator()));
            string = comment + System.lineSeparator() + System.lineSeparator() + string;
        }
        FileUtils.write((File)this.fileConfig.getFile(), (CharSequence)string, (Charset)StandardCharsets.UTF_8);
        return config;
    }

    private T validate(T config) {
        try {
            config.validatePostLoad();
        }
        catch (ConfigData.ValidationException ex) {
            logger.error("Failed to load config '{}'. Using default!", this.configClass, (Object)ex);
            config = this.createDefault();
            try {
                config.validatePostLoad();
            }
            catch (ConfigData.ValidationException ex2) {
                throw new RuntimeException("Result of createDefault() was invalid!", ex2);
            }
        }
        return config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveToFileConfig(Object object, Class<?> clazz, CommentedConfig destination, Object defaultConfig) throws IllegalAccessException, InvocationTargetException {
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                int fieldModifiers;
                if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class) || Modifier.isTransient(fieldModifiers = field.getModifiers())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Object defaultValue = field.get(defaultConfig);
                Object value = this.checkField(field, field.get(object), defaultValue);
                Converter converter = (Converter)getConverter.invoke(null, field);
                if (converter != null) {
                    value = converter.convertFromField(value);
                }
                List<String> path = this.getPath(field);
                ConfigFormat format = destination.configFormat();
                boolean category = false;
                if (value == null) {
                    destination.set(path, null);
                } else {
                    Class<?> valueType = value.getClass();
                    if (Enum.class.isAssignableFrom(valueType)) {
                        if (destination.configFormat().supportsType(Enum.class)) {
                            destination.set(path, value);
                        } else {
                            destination.set(path, (Object)value.toString());
                        }
                    } else if (field.isAnnotationPresent(ForceBreakdown.class) || !format.supportsType(valueType)) {
                        category = true;
                        destination.set(path, value);
                        CommentedConfig converted = destination.createSubConfig();
                        if (value instanceof ConfigData) {
                            try {
                                ((ConfigData)value).validatePostLoad();
                            }
                            catch (ConfigData.ValidationException ex) {
                                logger.error("Failed to load '{}' in config '{}. Using default!", path, this.configClass, (Object)ex);
                                value = defaultValue;
                                try {
                                    ((ConfigData)value).validatePostLoad();
                                }
                                catch (ConfigData.ValidationException ex2) {
                                    throw new RuntimeException("Result of createDefault() was invalid!", ex2);
                                }
                            }
                        }
                        this.moveToFileConfig(value, valueType, converted, defaultValue);
                        destination.set(path, (Object)converted);
                    } else if (value instanceof Collection) {
                        Collection source = (Collection)value;
                        Class bottomType = (Class)bottomElementType.invoke((Object)objectConverter, source);
                        if (!format.supportsType(bottomType)) throw new UnsupportedOperationException("Collections of objects are not supported!");
                        destination.set(path, value);
                    } else {
                        destination.set(path, value);
                    }
                }
                ArrayList<String> commentLines = new ArrayList<String>();
                if (field.isAnnotationPresent(Comment.class)) {
                    Collections.addAll(commentLines, field.getAnnotation(Comment.class).value());
                }
                if (!category) {
                    SpecIntInRange range;
                    if (field.isAnnotationPresent(SpecIntInRange.class)) {
                        range = field.getAnnotation(SpecIntInRange.class);
                        commentLines.add("Min: " + range.min());
                        commentLines.add("Max: " + range.max());
                    } else if (field.isAnnotationPresent(SpecLongInRange.class)) {
                        range = field.getAnnotation(SpecLongInRange.class);
                        commentLines.add("Min: " + range.min());
                        commentLines.add("Max: " + range.max());
                    } else if (field.isAnnotationPresent(SpecDoubleInRange.class)) {
                        range = field.getAnnotation(SpecDoubleInRange.class);
                        commentLines.add("Min: " + range.min());
                        commentLines.add("Max: " + range.max());
                    } else if (field.isAnnotationPresent(SpecFloatInRange.class)) {
                        range = field.getAnnotation(SpecFloatInRange.class);
                        commentLines.add("Min: " + range.min());
                        commentLines.add("Max: " + range.max());
                    }
                    Object convertedDefaultValue = converter == null ? defaultValue : converter.convertFromField(value);
                    CharsWrapper.Builder builder = new CharsWrapper.Builder(16);
                    write.invoke(null, convertedDefaultValue, builder, tomlWriter);
                    commentLines.add("Default: " + builder);
                }
                if (commentLines.isEmpty()) continue;
                String comment = commentLines.stream().map(line -> " " + line).collect(Collectors.joining(System.lineSeparator()));
                destination.setComment(path, comment);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void moveToObjectConfig(UnmodifiableConfig config, Object object, Class<?> clazz, Object defaultConfig) throws IllegalAccessException, InvocationTargetException {
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                List<String> path;
                int fieldModifiers;
                if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class) || Modifier.isTransient(fieldModifiers = field.getModifiers())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if (config.getRaw(path = this.getPath(field)) == null) {
                    field.set(object, field.get(defaultConfig));
                    continue;
                }
                Object value = config.get(path);
                Converter converter = (Converter)getConverter.invoke(null, field);
                if (converter != null) {
                    value = converter.convertToField(value);
                }
                Class<?> fieldType = field.getType();
                Object defaultValue = field.get(defaultConfig);
                try {
                    if (value instanceof UnmodifiableConfig && !fieldType.isAssignableFrom(value.getClass())) {
                        UnmodifiableConfig subconfig = (UnmodifiableConfig)value;
                        Object fieldValue = field.get(object);
                        if (fieldValue == null) {
                            fieldValue = Utils.constructUnsafely(fieldType);
                            field.set(object, fieldValue);
                            this.moveToObjectConfig(subconfig, fieldValue, fieldType, defaultValue);
                            continue;
                        }
                        if (((Boolean)mustPreserve.invoke(null, field, clazz)).booleanValue()) continue;
                        this.moveToObjectConfig(subconfig, fieldValue, fieldType, defaultValue);
                        continue;
                    }
                    if (value instanceof Collection && Collection.class.isAssignableFrom(fieldType)) {
                        Collection source = (Collection)value;
                        Class sourceBottomType = (Class)bottomElementType.invoke((Object)objectConverter, source);
                        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                        List destinationTypes = (List)elementTypes.invoke((Object)objectConverter, genericType);
                        Class destinationBottomType = (Class)destinationTypes.get(destinationTypes.size() - 1);
                        if (sourceBottomType == null || destinationBottomType == null || destinationBottomType.isAssignableFrom(sourceBottomType)) {
                            value = this.checkField(field, value, defaultValue);
                            field.set(object, value);
                            continue;
                        }
                        throw new UnsupportedOperationException("Collections of objects are not supported!");
                    }
                    if (value == null && ((Boolean)mustPreserve.invoke(null, field, clazz)).booleanValue()) {
                        this.checkField(field, field.get(object), defaultValue);
                        continue;
                    }
                    this.checkField(field, value, defaultValue);
                    if (fieldType.isEnum()) {
                        Class<?> enumType = fieldType;
                        SpecEnum specEnum = field.getAnnotation(SpecEnum.class);
                        EnumGetMethod method = specEnum == null ? EnumGetMethod.NAME_IGNORECASE : specEnum.method();
                        field.set(object, method.get(value, enumType));
                        continue;
                    }
                    if (value != null && value.getClass() == Double.class && (fieldType == Float.TYPE || fieldType == Float.class)) {
                        value = Float.valueOf((float)((Double)value).doubleValue());
                    }
                    field.set(object, value);
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("Failed to deserialize: " + field, ex);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private List<String> getPath(Field field) throws IllegalAccessException, InvocationTargetException {
        return ((List)getPath.invoke(null, field)).stream().map(element -> CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, element)).collect(Collectors.toList());
    }

    private Object checkField(Field field, Object value, Object defaultValue) throws IllegalAccessException, InvocationTargetException {
        try {
            checkField.invoke(null, field, value);
            return value;
        }
        catch (InvocationTargetException ex) {
            if (!(ex.getCause() instanceof InvalidValueException)) {
                throw ex;
            }
            value = defaultValue;
            checkField.invoke(null, field, value);
            return value;
        }
    }

    private static Class<?> findClassInSamePackage(Class<?> clazz, String name) {
        try {
            return Class.forName(clazz.getPackage().getName() + '.' + name);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Class<Converter> annotationUtils = TOMLConfigSerializer.findClassInSamePackage(Converter.class, "AnnotationUtils");
        mustPreserve = TOMLConfigSerializer.findMethod(annotationUtils, "mustPreserve", Field.class, Class.class);
        getConverter = TOMLConfigSerializer.findMethod(annotationUtils, "getConverter", Field.class);
        getPath = TOMLConfigSerializer.findMethod(annotationUtils, "getPath", Field.class);
        checkField = TOMLConfigSerializer.findMethod(annotationUtils, "checkField", Field.class, Object.class);
        bottomElementType = TOMLConfigSerializer.findMethod(ObjectConverter.class, "bottomElementType", Collection.class);
        elementTypes = TOMLConfigSerializer.findMethod(ObjectConverter.class, "elementTypes", ParameterizedType.class);
        write = TOMLConfigSerializer.findMethod(TOMLConfigSerializer.findClassInSamePackage(TomlWriter.class, "ValueWriter"), "write", Object.class, CharacterOutput.class, TomlWriter.class);
        load = TOMLConfigSerializer.findMethod(ConfigManager.class, "load", new Class[0]);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Comment {
        public String[] value();
    }
}

