/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.WithdrawSeedsMessage;
import vazkii.quark.content.tools.capability.SeedPouchDropIn;
import vazkii.quark.content.tools.item.SeedPouchItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class SeedPouchModule
extends QuarkModule {
    private static final ResourceLocation SEED_POUCH_CAP = new ResourceLocation("quark", "seed_pouch_drop_in");
    public static Item seed_pouch;
    public static ITag<Item> seedPouchHoldableTag;
    @Config
    public static int maxItems;
    @Config
    public static boolean showAllVariantsInCreative;
    @Config
    public static int shiftRange;
    private static boolean shouldCancelNextRelease;

    @Override
    public void construct() {
        seed_pouch = new SeedPouchItem(this);
    }

    @Override
    public void setup() {
        seedPouchHoldableTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("quark", "seed_pouch_holdable"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        this.enqueue(() -> ItemModelsProperties.func_239418_a_((Item)seed_pouch, (ResourceLocation)new ResourceLocation("pouch_items"), SeedPouchItem::itemFraction));
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == seed_pouch) {
            event.addCapability(SEED_POUCH_CAP, (ICapabilityProvider)new SeedPouchDropIn());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRightClick(GuiScreenEvent.MouseClickedEvent.Pre event) {
        ContainerScreen container;
        Slot under;
        Minecraft mc = Minecraft.func_71410_x();
        Screen gui = mc.field_71462_r;
        if (gui instanceof ContainerScreen && !(gui instanceof CreativeScreen) && event.getButton() == 1 && (under = (container = (ContainerScreen)gui).getSlotUnderMouse()) != null) {
            Pair<ItemStack, Integer> contents;
            ItemStack underStack = under.func_75211_c();
            ItemStack held = mc.field_71439_g.field_71071_by.func_70445_o();
            if (underStack.func_77973_b() == seed_pouch && (contents = SeedPouchItem.getContents(underStack)) != null) {
                ItemStack seed = (ItemStack)contents.getLeft();
                if (held.func_190926_b()) {
                    int takeOut = Math.min(seed.func_77976_d(), (Integer)contents.getRight());
                    ItemStack result = seed.func_77946_l();
                    result.func_190920_e(takeOut);
                    mc.field_71439_g.field_71071_by.func_70437_b(result);
                    QuarkNetwork.sendToServer(new WithdrawSeedsMessage(under.field_75222_d));
                    shouldCancelNextRelease = true;
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onRightClickRelease(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        if (shouldCancelNextRelease) {
            shouldCancelNextRelease = false;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItem().func_92059_d();
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        ImmutableSet stacks = ImmutableSet.of((Object)main, (Object)off);
        for (ItemStack heldStack : stacks) {
            ItemStack pouchStack;
            Pair<ItemStack, Integer> contents;
            if (heldStack.func_77973_b() != seed_pouch || (contents = SeedPouchItem.getContents(heldStack)) == null || !ItemStack.func_179545_c((ItemStack)(pouchStack = (ItemStack)contents.getLeft()), (ItemStack)stack)) continue;
            int curr = (Integer)contents.getRight();
            int missing = maxItems - curr;
            int count = stack.func_190916_E();
            int toAdd = Math.min(missing, count);
            stack.func_190920_e(count - toAdd);
            SeedPouchItem.setCount(heldStack, curr + toAdd);
            if (player.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)player.field_70170_p).func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 0.2f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 1.4f + 2.0f);
            }
            if (stack.func_190916_E() != 0) continue;
            break;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void makeTooltip(ItemTooltipEvent event) {
        Pair<ItemStack, Integer> contents;
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == seed_pouch && (contents = SeedPouchItem.getContents(stack)) != null) {
            List tooltip = event.getToolTip();
            int stacks = Math.max(1, ((Integer)contents.getRight() - 1) / ((ItemStack)contents.getLeft()).func_77976_d() + 1);
            int len = 16 + stacks * 8;
            String s = "";
            Minecraft mc = Minecraft.func_71410_x();
            while (mc.field_71466_p.func_78256_a(s) < len) {
                s = s + " ";
            }
            tooltip.add(1, new StringTextComponent(s));
            tooltip.add(1, new StringTextComponent(s));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        Pair<ItemStack, Integer> contents;
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() == seed_pouch && (contents = SeedPouchItem.getContents(stack)) != null) {
            ItemStack seed = ((ItemStack)contents.getLeft()).func_77946_l();
            Minecraft mc = Minecraft.func_71410_x();
            ItemRenderer render = mc.func_175599_af();
            int x = event.getX();
            int y = event.getY();
            int count = (Integer)contents.getRight();
            int stacks = Math.max(1, (count - 1) / seed.func_77976_d() + 1);
            GlStateManager.func_227626_N_();
            GlStateManager.func_227670_b_((double)x, (double)(y + 12), (double)500.0);
            for (int i = 0; i < stacks; ++i) {
                if (i == stacks - 1) {
                    seed.func_190920_e(count);
                }
                GlStateManager.func_227626_N_();
                GlStateManager.func_227670_b_((double)(8 * i), (double)(Math.sin(i * 498543) * 2.0), (double)0.0);
                render.func_180450_b(seed, 0, 0);
                render.func_175030_a(mc.field_71466_p, seed, 0, 0);
                GlStateManager.func_227627_O_();
            }
            GlStateManager.func_227627_O_();
        }
    }

    static {
        maxItems = 640;
        showAllVariantsInCreative = true;
        shiftRange = 3;
        shouldCancelNextRelease = false;
    }
}

