/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.content.automation.base.ChainHandler;

@OnlyIn(value=Dist.CLIENT)
public class ChainRenderer {
    private static final IntObjectMap<Entity> RENDER_MAP = new IntObjectHashMap();

    private static void renderLeash(EntityRenderer<Entity> renderer, Entity cart, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderBuffer, Entity holder) {
        Entity entity = holder;
        if (entity != null && holder != null) {
            boolean player = entity instanceof PlayerEntity;
            double yaw = (double)MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)entity.field_70126_B, (float)entity.field_70177_z) * Math.PI / 180.0;
            double pitch = (double)MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)entity.field_70127_C, (float)entity.field_70125_A) * Math.PI / 180.0;
            double rotX = Math.cos(yaw);
            double rotZ = Math.sin(yaw);
            double rotY = Math.sin(pitch);
            float xLocus = (float)MathHelper.func_219803_d((double)partialTicks, (double)ChainRenderer.prevX(entity), (double)entity.func_226277_ct_());
            float yLocus = (float)MathHelper.func_219803_d((double)partialTicks, (double)ChainRenderer.prevY(entity), (double)entity.func_226278_cu_());
            float zLocus = (float)MathHelper.func_219803_d((double)partialTicks, (double)ChainRenderer.prevZ(entity), (double)entity.func_226281_cx_());
            if (player) {
                xLocus = (float)((double)xLocus + rotX);
                zLocus = (float)((double)zLocus + rotZ);
                yLocus = (float)((double)yLocus + 1.3);
            }
            float targetX = (float)MathHelper.func_219803_d((double)partialTicks, (double)ChainRenderer.prevX(cart), (double)cart.func_226277_ct_());
            float targetY = (float)MathHelper.func_219803_d((double)partialTicks, (double)ChainRenderer.prevY(cart), (double)cart.func_226278_cu_());
            float targetZ = (float)MathHelper.func_219803_d((double)partialTicks, (double)ChainRenderer.prevZ(cart), (double)cart.func_226281_cx_());
            if (player) {
                xLocus = (float)((double)xLocus - rotX);
                zLocus = (float)((double)zLocus - rotZ);
            }
            float offsetX = xLocus - targetX;
            float offsetY = yLocus - targetY;
            float offsetZ = zLocus - targetZ;
            IVertexBuilder vertexBuilder = renderBuffer.getBuffer(RenderType.func_228649_h_());
            int lightAtEntity = ChainRenderer.getBlockLight(entity, partialTicks);
            int lightAtOther = ChainRenderer.getBlockLight(holder, partialTicks);
            int skyLightAtEntity = entity.field_70170_p.func_226658_a_(LightType.SKY, new BlockPos(entity.func_174824_e(partialTicks)));
            int skyLightAtOther = entity.field_70170_p.func_226658_a_(LightType.SKY, new BlockPos(holder.func_174824_e(partialTicks)));
            float mag = MathHelper.func_226165_i_((float)(offsetX * offsetX + offsetZ * offsetZ)) * 0.025f / 2.0f;
            float zMag = offsetZ * mag;
            float xMag = offsetX * mag;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, (double)0.1f, 0.0);
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            ChainRenderer.renderSide(vertexBuilder, matrix, offsetX, offsetY, offsetZ, lightAtEntity, lightAtOther, skyLightAtEntity, skyLightAtOther, 0.025f, 0.025f, zMag, xMag);
            ChainRenderer.renderSide(vertexBuilder, matrix, offsetX, offsetY, offsetZ, lightAtEntity, lightAtOther, skyLightAtEntity, skyLightAtOther, 0.025f, 0.0f, zMag, xMag);
            matrixStack.func_227865_b_();
        }
    }

    private static int getBlockLight(Entity entityIn, float partialTicks) {
        return entityIn.func_70027_ad() ? 15 : entityIn.field_70170_p.func_226658_a_(LightType.BLOCK, new BlockPos(entityIn.func_174824_e(partialTicks)));
    }

    public static void renderSide(IVertexBuilder vertexBuilder, Matrix4f matrix, float dX, float dY, float dZ, int lightAtEntity, int lightAtOther, int skyLightAtEntity, int skyLightAtOther, float width, float rotation, float xMag, float zMag) {
        for (int stepIdx = 0; stepIdx < 24; ++stepIdx) {
            float step = (float)stepIdx / 23.0f;
            int brightness = (int)MathHelper.func_219799_g((float)step, (float)lightAtEntity, (float)lightAtOther);
            int skyBrightness = (int)MathHelper.func_219799_g((float)step, (float)skyLightAtEntity, (float)skyLightAtOther);
            int light = LightTexture.func_228451_a_((int)brightness, (int)skyBrightness);
            ChainRenderer.addVertexPair(vertexBuilder, matrix, light, dX, dY, dZ, width, rotation, 24, stepIdx, false, xMag, zMag);
            ChainRenderer.addVertexPair(vertexBuilder, matrix, light, dX, dY, dZ, width, rotation, 24, stepIdx + 1, true, xMag, zMag);
        }
    }

    public static void addVertexPair(IVertexBuilder vertexBuilder, Matrix4f matrix, int light, float dX, float dY, float dZ, float width, float rotation, int steps, int stepIdx, boolean leading, float xMag, float zMag) {
        float r = 0.3f;
        float g = 0.3f;
        float b = 0.3f;
        if (stepIdx % 2 == 0) {
            r *= 0.7f;
            g *= 0.7f;
            b *= 0.7f;
        }
        float step = (float)stepIdx / (float)steps;
        float x = dX * step;
        float y = dY * (step * step + step) * 0.5f;
        float z = dZ * step;
        if (!leading) {
            vertexBuilder.func_227888_a_(matrix, x + xMag, y + width - rotation, z - zMag).func_227885_a_(r, g, b, 1.0f).func_227886_a_(light).func_181675_d();
        }
        vertexBuilder.func_227888_a_(matrix, x - xMag, y + rotation, z + zMag).func_227885_a_(r, g, b, 1.0f).func_227886_a_(light).func_181675_d();
        if (leading) {
            vertexBuilder.func_227888_a_(matrix, x + xMag, y + width - rotation, z - zMag).func_227885_a_(r, g, b, 1.0f).func_227886_a_(light).func_181675_d();
        }
    }

    public static void renderChain(EntityRenderer<Entity> render, Entity entity, MatrixStack matrixStack, IRenderTypeBuffer renderBuffer, float partTicks) {
        Entity holder;
        if (ChainHandler.canBeLinked(entity) && (holder = (Entity)RENDER_MAP.get(entity.func_145782_y())) != null) {
            ChainRenderer.renderLeash(render, entity, partTicks, matrixStack, renderBuffer, holder);
        }
    }

    private static double prevX(Entity entity) {
        if (entity instanceof AbstractMinecartEntity) {
            return entity.field_70142_S;
        }
        return entity.field_70169_q;
    }

    private static double prevY(Entity entity) {
        if (entity instanceof AbstractMinecartEntity) {
            return entity.field_70137_T;
        }
        return entity.field_70167_r;
    }

    private static double prevZ(Entity entity) {
        if (entity instanceof AbstractMinecartEntity) {
            return entity.field_70136_U;
        }
        return entity.field_70166_s;
    }

    private static double renderYawOffset(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).field_70761_aq;
        }
        return 0.0;
    }

    private static double prevRenderYawOffset(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).field_70760_ar;
        }
        return 0.0;
    }

    public static void updateTick() {
        RENDER_MAP.clear();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        for (Entity entity : world.func_217416_b()) {
            Entity other;
            if (!ChainHandler.canBeLinked(entity) || (other = ChainHandler.getLinked(entity)) == null) continue;
            RENDER_MAP.put(entity.func_145782_y(), (Object)other);
        }
    }
}

