/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.DistType;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.core.v1.ObjectShareAccess;
import fuzs.puzzleslib.api.core.v1.ServiceProviderHelper;
import fuzs.puzzleslib.impl.core.ModContext;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public interface ModLoaderEnvironment {
    public static final ModLoaderEnvironment INSTANCE = ServiceProviderHelper.load(ModLoaderEnvironment.class);

    public ModLoader getModLoader();

    default public boolean isForge() {
        return this.getModLoader().isForge();
    }

    default public boolean isFabric() {
        return this.getModLoader().isFabric();
    }

    default public boolean isQuilt() {
        return this.getModLoader().isQuilt();
    }

    @Deprecated(forRemoval=true)
    default public DistType getEnvironmentType() {
        return this.isClient() ? DistType.CLIENT : DistType.SERVER;
    }

    @Deprecated(forRemoval=true)
    default public boolean isEnvironmentType(DistType envType) {
        return this.getEnvironmentType() == envType;
    }

    public boolean isClient();

    public boolean isServer();

    public Path getGameDirectory();

    public Path getModsDirectory();

    public Path getConfigDirectory();

    public boolean isDevelopmentEnvironment();

    public Map<String, ModContainer> getModList();

    default public boolean isModLoaded(String modId) {
        return this.getModList().containsKey(modId);
    }

    default public Optional<ModContainer> getModContainer(String modId) {
        return this.isModLoaded(modId) ? Optional.of(this.getModList().get(modId)) : Optional.empty();
    }

    default public boolean isModPresentServerside(String modId) {
        return ModContext.isPresentServerside(modId);
    }

    @Deprecated(forRemoval=true)
    default public boolean isModLoadedSafe(String modId) {
        return this.isModLoaded(modId);
    }

    @Deprecated(forRemoval=true)
    default public Optional<String> getModName(String modId) {
        return this.getModContainer(modId).map(ModContainer::getDisplayName);
    }

    @Deprecated(forRemoval=true)
    default public Optional<Path> findModResource(String modId, String ... path) {
        return this.getModContainer(modId).flatMap(t -> t.findResource(path));
    }

    public ObjectShareAccess getObjectShareAccess();
}

