/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8103;
import net.puffish.skillsmod.access.DamageSourceAccess;
import net.puffish.skillsmod.access.EntityAttributeInstanceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.builtin.TakeDamageExperienceSource;
import net.puffish.skillsmod.server.setup.SkillsAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    private int entityDroppedXp = 0;

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyVariableAtDamage(float damage, class_1282 source) {
        if (damage < 0.0f) {
            return damage;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (source.method_48789(class_8103.field_42247)) {
                attribute = (EntityAttributeInstanceAccess)player.method_5996(SkillsAttributes.RANGED_DAMAGE);
                damage = (float)attribute.computeIncreasedValueForInitial(damage);
            } else {
                attribute = (EntityAttributeInstanceAccess)player.method_5996(SkillsAttributes.MELEE_DAMAGE);
                damage = (float)attribute.computeIncreasedValueForInitial(damage);
            }
        }
        return damage;
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void injectAtDamage(class_1282 source, float damage, CallbackInfoReturnable<Boolean> cir) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            SkillsAPI.visitExperienceSources(serverPlayer, experienceSource -> {
                if (experienceSource instanceof TakeDamageExperienceSource) {
                    TakeDamageExperienceSource takeDamageExperienceSource = (TakeDamageExperienceSource)experienceSource;
                    return takeDamageExperienceSource.getValue(serverPlayer, damage, source);
                }
                return 0;
            });
        }
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.method_5996(SkillsAttributes.HEALING);
            amount = (float)attribute.computeIncreasedValueForInitial(amount);
        }
        return amount;
    }

    @Inject(method={"getJumpVelocity"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectAtGetJumpVelocity(CallbackInfoReturnable<Float> cir) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.method_5996(SkillsAttributes.JUMP);
            cir.setReturnValue((Object)Float.valueOf((float)attribute.computeIncreasedValueForInitial(cir.getReturnValueF())));
        }
    }

    @ModifyVariable(method={"computeFallDamage"}, at=@At(value="STORE"), ordinal=2)
    private float modifyVariableAtComputeFallDamage(float reduction) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.method_5996(SkillsAttributes.JUMP);
            reduction = (float)((double)reduction + (attribute.computeIncreasedValueForInitial(1.0) - 1.0) * 10.0);
        }
        return reduction;
    }

    @Inject(method={"drop"}, at={@At(value="TAIL")})
    private void injectAtDrop(class_1282 source, CallbackInfo ci) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_1309 entity = (class_1309)this;
            class_1799 weapon = ((DamageSourceAccess)source).getWeapon().orElse(class_1799.field_8037);
            WorldChunkAccess worldChunk = (WorldChunkAccess)entity.method_37908().method_8500(entity.method_24515());
            worldChunk.antiFarmingCleanupOutdated();
            SkillsAPI.visitExperienceSources(player, experienceSource -> {
                if (experienceSource instanceof KillEntityExperienceSource) {
                    KillEntityExperienceSource entityExperienceSource = (KillEntityExperienceSource)experienceSource;
                    if (entityExperienceSource.getAntiFarming().map(worldChunk::antiFarmingAddAndCheck).orElse(true).booleanValue()) {
                        return entityExperienceSource.getValue(player, entity, weapon, source, this.entityDroppedXp);
                    }
                }
                return 0;
            });
        }
    }

    @ModifyArg(method={"dropXp"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    private int injectAtDropXp(int droppedXp) {
        this.entityDroppedXp = droppedXp;
        return droppedXp;
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectAtModifyAppliedDamage(CallbackInfoReturnable<Float> cir) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (cir.getReturnValueF() < 1.1342745E38f) {
                EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.method_5996(SkillsAttributes.RESISTANCE);
                cir.setReturnValue((Object)Float.valueOf(Math.max(0.0f, (float)attribute.computeDecreasedValueForInitial(cir.getReturnValueF()))));
            }
        }
    }
}

