/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.expression.BinaryOperator;
import net.puffish.skillsmod.expression.Expression;
import net.puffish.skillsmod.expression.FunctionOperator;
import net.puffish.skillsmod.expression.GroupOperator;
import net.puffish.skillsmod.expression.Lexer;
import net.puffish.skillsmod.expression.UnaryOperator;

public class Parser<T> {
    private Lexer lexer;
    private final List<UnaryOperator<T>> unaryOperators;
    private final List<BinaryOperator<T>> binaryOperators;
    private final List<GroupOperator> groupOperators;
    private final List<FunctionOperator<T>> functionOperators;
    private final Function<String, Result<Expression<T>, Failure>> otherHandler;
    private final List<Failure> failures = new ArrayList<Failure>();

    private Parser(Lexer lexer, List<UnaryOperator<T>> unaryOperators, List<BinaryOperator<T>> binaryOperators, List<GroupOperator> groupOperators, List<FunctionOperator<T>> functionOperators, Function<String, Result<Expression<T>, Failure>> otherHandler) {
        this.lexer = lexer;
        this.unaryOperators = unaryOperators;
        this.binaryOperators = binaryOperators;
        this.groupOperators = groupOperators;
        this.functionOperators = functionOperators;
        this.otherHandler = otherHandler;
    }

    public static <T> Result<Expression<T>, Failure> parse(String expression, List<UnaryOperator<T>> unaryOperators, List<BinaryOperator<T>> binaryOperators, List<GroupOperator> groupOperators, List<FunctionOperator<T>> functionOperators, Function<String, Result<Expression<T>, Failure>> otherHandler) {
        return new Parser<T>(Lexer.create(expression), unaryOperators, binaryOperators, groupOperators, functionOperators, otherHandler).parse();
    }

    private Result<Expression<T>, Failure> parse() {
        Optional<Expression<T>> expression = this.tryParse();
        if (this.failures.isEmpty() && !this.lexer.isEnd()) {
            this.failures.add(Failure.message("Invalid expression"));
        }
        if (this.failures.isEmpty()) {
            return Result.success(expression.orElseThrow());
        }
        return Result.failure(Failure.fromMany(this.failures));
    }

    private Optional<Expression<T>> tryParse() {
        return this.tryParse(0);
    }

    private Optional<Expression<T>> tryParse(int precedence) {
        Optional<BinaryOperator<T>> optBinary;
        Optional<Expression<T>> optLeft = this.consumePrefix();
        if (optLeft.isEmpty()) {
            return Optional.empty();
        }
        Expression<T> left = optLeft.orElseThrow();
        while (!this.lexer.isEnd() && !(optBinary = this.testBinary(precedence)).isEmpty()) {
            BinaryOperator<T> binary = optBinary.orElseThrow();
            Optional<Expression<T>> optRight = this.tryParse(binary.precedence() + (binary.right() ? 0 : 1));
            if (optRight.isEmpty()) {
                return Optional.empty();
            }
            Expression<T> right = optRight.orElseThrow();
            left = binary.function().apply(left, right);
        }
        return Optional.of(left);
    }

    private Optional<BinaryOperator<T>> testBinary(int precedence) {
        for (BinaryOperator<T> binary : this.binaryOperators) {
            if (binary.precedence() < precedence || !this.lexer.consume(binary.token())) continue;
            return Optional.of(binary);
        }
        return Optional.empty();
    }

    private Optional<Expression<T>> consumePrefix() {
        for (UnaryOperator<T> unaryOperator : this.unaryOperators) {
            if (!this.lexer.consume(unaryOperator.token())) continue;
            return this.tryParse(unaryOperator.precedence()).map(expr -> unary.function().apply((Expression<Expression>)expr));
        }
        for (GroupOperator groupOperator : this.groupOperators) {
            if (!this.lexer.consume(groupOperator.openToken())) continue;
            Optional<Expression<T>> optExpression = this.tryParse();
            if (this.lexer.consume(groupOperator.closeToken())) {
                return optExpression;
            }
            return this.invalid();
        }
        for (FunctionOperator functionOperator : this.functionOperators) {
            Lexer testLexer = Lexer.copy(this.lexer);
            if (!testLexer.consume(functionOperator.name()) || !testLexer.consume(functionOperator.openToken())) continue;
            this.lexer = testLexer;
            if (this.lexer.consume(functionOperator.closeToken())) {
                if (functionOperator.args() != -1 && functionOperator.args() != 0) {
                    return this.invalid();
                }
                return Optional.of(functionOperator.function().apply(List.of()));
            }
            ArrayList<Expression<T>> args = new ArrayList<Expression<T>>();
            do {
                Optional<Expression<T>> optExpression;
                if ((optExpression = this.tryParse()).isEmpty()) {
                    return Optional.empty();
                }
                args.add(optExpression.orElseThrow());
                if (!this.lexer.consume(functionOperator.closeToken())) continue;
                if (functionOperator.args() != -1 && functionOperator.args() != args.size()) {
                    return this.invalid();
                }
                return Optional.of(functionOperator.function().apply(args));
            } while (this.lexer.consume(functionOperator.separatorToken()));
            return this.invalid();
        }
        Optional<String> optToken = this.lexer.consumeOther();
        if (optToken.isPresent()) {
            String string = optToken.orElseThrow();
            return Optional.of(this.otherHandler.apply(string).ifFailure(this.failures::add).getSuccessOrElse(e -> v -> null));
        }
        return this.invalid();
    }

    private <R> Optional<R> invalid() {
        this.failures.add(Failure.message("Invalid expression"));
        return Optional.empty();
    }
}

