/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

public class ModConfig {
    private final boolean showWarnings;
    private final List<String> categories;

    private ModConfig(boolean showWarnings, List<String> categories) {
        this.showWarnings = showWarnings;
        this.categories = categories;
    }

    public static Result<ModConfig, Failure> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(ModConfig::parse);
    }

    public static Result<ModConfig, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Integer version = rootObject.getInt("version").getSuccessOrElse(e -> Integer.MIN_VALUE);
        Boolean showWarnings = rootObject.getBoolean("show_warnings").getSuccessOrElse(e -> false);
        if (version < 1) {
            return Result.failure(Failure.message("Configuration is outdated. Check out the mod's wiki to learn how to update the configuration."));
        }
        if (version > 1) {
            return Result.failure(Failure.message("Configuration is for a newer version of the mod. Please update the mod."));
        }
        Optional optCategories = rootObject.getArray("categories").andThen(array -> array.getAsList((i, element) -> JsonParseUtils.parseIdentifierPath(element)).mapFailure(Failure::fromMany)).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new ModConfig(showWarnings, (List)optCategories.orElseThrow()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    public boolean getShowWarnings() {
        return this.showWarnings;
    }

    public List<String> getCategories() {
        return this.categories;
    }
}

