/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.experience.ExperienceConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionsConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;

public class CategoryConfig {
    private final class_2960 id;
    private final GeneralConfig general;
    private final SkillDefinitionsConfig definitions;
    private final SkillsConfig skills;
    private final SkillConnectionsConfig connections;
    private final Optional<ExperienceConfig> optExperience;

    private CategoryConfig(class_2960 id, GeneralConfig general, SkillDefinitionsConfig definitions, SkillsConfig skills, SkillConnectionsConfig connections, Optional<ExperienceConfig> optExperience) {
        this.id = id;
        this.general = general;
        this.definitions = definitions;
        this.skills = skills;
        this.connections = connections;
        this.optExperience = optExperience;
    }

    public static Result<CategoryConfig, Failure> parse(class_2960 id, JsonElementWrapper generalElement, JsonElementWrapper definitionsElement, JsonElementWrapper skillsElement, JsonElementWrapper connectionsElement, Optional<JsonElementWrapper> optExperienceElement, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<GeneralConfig> optGeneral = GeneralConfig.parse(generalElement).ifFailure(failures::add).getSuccess();
        Optional<ExperienceConfig> optExperience = optExperienceElement.flatMap(experience -> ExperienceConfig.parse(experience, context).ifFailure(failures::add).getSuccess().flatMap(Function.identity()));
        Optional<SkillDefinitionsConfig> optDefinitions = SkillDefinitionsConfig.parse(definitionsElement, context).ifFailure(failures::add).getSuccess();
        Optional optSkills = optDefinitions.flatMap(definitions -> SkillsConfig.parse(skillsElement, definitions).ifFailure(failures::add).getSuccess());
        Optional optConnections = optSkills.flatMap(skills -> SkillConnectionsConfig.parse(connectionsElement, skills).ifFailure(failures::add).getSuccess());
        if (failures.isEmpty()) {
            return Result.success(new CategoryConfig(id, optGeneral.orElseThrow(), optDefinitions.orElseThrow(), (SkillsConfig)optSkills.orElseThrow(), (SkillConnectionsConfig)optConnections.orElseThrow(), optExperience));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    public void dispose(MinecraftServer server) {
        this.definitions.dispose(server);
        this.optExperience.ifPresent(experience -> experience.dispose(server));
    }

    public class_2960 getId() {
        return this.id;
    }

    public GeneralConfig getGeneral() {
        return this.general;
    }

    public SkillDefinitionsConfig getDefinitions() {
        return this.definitions;
    }

    public SkillsConfig getSkills() {
        return this.skills;
    }

    public SkillConnectionsConfig getConnections() {
        return this.connections;
    }

    public Optional<ExperienceConfig> getExperience() {
        return this.optExperience;
    }
}

