/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import net.puffish.skillsmod.access.ImmediateAccess;
import net.puffish.skillsmod.access.MinecraftClientAccess;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ItemBatchedRenderer {
    private final Map<ComparableItemStack, List<ItemEmit>> batch = new HashMap<ComparableItemStack, List<ItemEmit>>();

    public void emitItem(class_332 context, class_1799 item, int x, int y) {
        List emits = this.batch.computeIfAbsent(new ComparableItemStack(item), key -> new ArrayList());
        emits.add(new ItemEmit(context.method_51448().method_23760().method_23761(), x, y));
    }

    public void draw() {
        class_4587 matrices = new class_4587();
        matrices.method_46416(0.0f, 0.0f, 150.0f);
        matrices.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrices.method_22905(16.0f, 16.0f, 16.0f);
        for (Map.Entry<ComparableItemStack, List<ItemEmit>> entry : this.batch.entrySet()) {
            class_1799 itemStack = entry.getKey().itemStack;
            class_310 client = class_310.method_1551();
            class_1087 bakedModel = client.method_1480().method_4019(itemStack, (class_1937)client.field_1687, (class_1309)client.field_1724, 0);
            if (bakedModel.method_24304()) {
                class_308.method_24211();
            } else {
                class_308.method_24210();
            }
            MinecraftClientAccess clientAccess = (MinecraftClientAccess)client;
            ImmediateAccess immediateAccess = (ImmediateAccess)clientAccess.getBufferBuilders().method_23000();
            BatchedImmediate vertexConsumerProvider = new BatchedImmediate(immediateAccess.getFallbackBuffer(), immediateAccess.getLayerBuffers(), entry.getValue());
            client.method_1480().method_23179(itemStack, class_811.field_4317, false, matrices, (class_4597)vertexConsumerProvider, 0xF000F0, class_4608.field_21444, bakedModel);
            vertexConsumerProvider.draw();
        }
        this.batch.clear();
    }

    private record ComparableItemStack(class_1799 itemStack) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return class_1799.method_7973((class_1799)this.itemStack, (class_1799)((ComparableItemStack)o).itemStack);
        }

        @Override
        public int hashCode() {
            return this.itemStack.method_7909().hashCode();
        }
    }

    private record ItemEmit(Matrix4f matrix, int x, int y) {
    }

    private static class BatchedImmediate
    implements class_4597 {
        private final List<ItemEmit> emits;
        private final class_287 fallbackBuffer;
        private final Map<class_1921, class_287> layerBuffers;
        private Optional<class_1921> optCurrentLayer = Optional.empty();
        private final Set<class_287> activeConsumers = Sets.newHashSet();

        private BatchedImmediate(class_287 fallbackBuffer, Map<class_1921, class_287> layerBuffers, List<ItemEmit> emits) {
            this.fallbackBuffer = fallbackBuffer;
            this.layerBuffers = layerBuffers;
            this.emits = emits;
        }

        public class_4588 getBuffer(class_1921 layer) {
            Optional optLayer = layer.method_24296();
            class_287 bufferBuilder = this.getBufferInternal(layer);
            if (!Objects.equals(this.optCurrentLayer, optLayer) || !layer.method_43332()) {
                this.optCurrentLayer.ifPresent(currentLayer -> {
                    if (!this.layerBuffers.containsKey(currentLayer)) {
                        this.draw((class_1921)currentLayer);
                    }
                });
                if (this.activeConsumers.add(bufferBuilder)) {
                    bufferBuilder.method_1328(layer.method_23033(), layer.method_23031());
                }
                this.optCurrentLayer = optLayer;
            }
            return bufferBuilder;
        }

        private class_287 getBufferInternal(class_1921 layer) {
            return this.layerBuffers.getOrDefault(layer, this.fallbackBuffer);
        }

        public void draw() {
            this.optCurrentLayer.ifPresent(layer -> {
                if (this.getBuffer((class_1921)layer) == this.fallbackBuffer) {
                    this.draw((class_1921)layer);
                }
            });
            for (class_1921 layer2 : this.layerBuffers.keySet()) {
                this.draw(layer2);
            }
        }

        private void draw(class_1921 layer) {
            class_287 bufferBuilder = this.getBufferInternal(layer);
            boolean same = Objects.equals(this.optCurrentLayer, layer.method_24296());
            if (!same && bufferBuilder == this.fallbackBuffer) {
                return;
            }
            if (!this.activeConsumers.remove(bufferBuilder)) {
                return;
            }
            bufferBuilder.method_49904(RenderSystem.getVertexSorting());
            class_287.class_7433 builtBuffer = bufferBuilder.method_1326();
            layer.method_23516();
            class_291 vertexBuffer = builtBuffer.method_43583().comp_749().method_43446();
            vertexBuffer.method_1353();
            vertexBuffer.method_1352(builtBuffer);
            for (ItemEmit emit : this.emits) {
                vertexBuffer.method_34427(new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix()).mul((Matrix4fc)emit.matrix()).translate((float)emit.x(), (float)emit.y(), 0.0f), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            }
            layer.method_23518();
            if (same) {
                this.optCurrentLayer = Optional.empty();
            }
        }
    }
}

