/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.data;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1060;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClientFrameData {

    public static class TextureFrameData
    implements ClientFrameData {
        private final class_2960 availableTexture;
        private final class_2960 unlockedTexture;
        private final class_2960 lockedTexture;
        private final class_2960 excludedTexture;

        public TextureFrameData(class_2960 availableTexture, class_2960 unlockedTexture, class_2960 lockedTexture, class_2960 excludedTexture) {
            this.availableTexture = availableTexture;
            this.unlockedTexture = unlockedTexture;
            this.lockedTexture = lockedTexture;
            this.excludedTexture = excludedTexture;
        }

        public static Result<TextureFrameData, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(TextureFrameData::parse);
        }

        private static Result<TextureFrameData, Failure> parse(JsonObjectWrapper rootObject) {
            ArrayList<Failure> failures = new ArrayList<Failure>();
            Optional optAvailableTexture = rootObject.get("available").andThen(JsonParseUtils::parseIdentifier).ifFailure(failures::add).getSuccess();
            Optional optUnlockedTexture = rootObject.get("unlocked").andThen(JsonParseUtils::parseIdentifier).ifFailure(failures::add).getSuccess();
            class_2960 lockedTexture = rootObject.get("locked").andThen(JsonParseUtils::parseIdentifier).getSuccess().orElse(null);
            class_2960 excludedTexture = rootObject.get("excluded").andThen(JsonParseUtils::parseIdentifier).getSuccess().orElse(null);
            if (failures.isEmpty()) {
                return Result.success(new TextureFrameData((class_2960)optAvailableTexture.orElseThrow(), (class_2960)optUnlockedTexture.orElseThrow(), lockedTexture, excludedTexture));
            }
            return Result.failure(Failure.fromMany(failures));
        }

        public static TextureFrameData createMissing() {
            return new TextureFrameData(class_1060.field_5285, class_1060.field_5285, class_1060.field_5285, class_1060.field_5285);
        }

        public class_2960 getLockedTexture() {
            return this.lockedTexture;
        }

        public class_2960 getAvailableTexture() {
            return this.availableTexture;
        }

        public class_2960 getUnlockedTexture() {
            return this.unlockedTexture;
        }

        public class_2960 getExcludedTexture() {
            return this.excludedTexture;
        }
    }

    public static class AdvancementFrameData
    implements ClientFrameData {
        private final class_189 frame;

        private AdvancementFrameData(class_189 frame) {
            this.frame = frame;
        }

        public static Result<AdvancementFrameData, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("frame")).andThen(JsonParseUtils::parseFrame).mapSuccess(AdvancementFrameData::new);
        }

        public class_189 getFrame() {
            return this.frame;
        }
    }
}

