/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.gui.SimpleToast;
import net.puffish.skillsmod.client.gui.SkillsScreen;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketReceiver;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.network.packets.in.ExperienceUpdateInPacket;
import net.puffish.skillsmod.client.network.packets.in.HideCategoryInPacket;
import net.puffish.skillsmod.client.network.packets.in.InvalidConfigInPacket;
import net.puffish.skillsmod.client.network.packets.in.PointsUpdateInPacket;
import net.puffish.skillsmod.client.network.packets.in.ShowCategoryInPacket;
import net.puffish.skillsmod.client.network.packets.in.SkillUpdateInPacket;
import net.puffish.skillsmod.network.Packets;

public class SkillsClientMod {
    public static final class_304 OPEN_KEY_BINDING = new class_304("key.puffish_skills.open", class_3675.class_307.field_1668, 75, "category.puffish_skills.skills");
    private static SkillsClientMod instance;
    private final Map<class_2960, ClientSkillCategoryData> categories = new LinkedHashMap<class_2960, ClientSkillCategoryData>();
    private final ClientPacketSender packetSender;

    private SkillsClientMod(ClientPacketSender packetSender) {
        this.packetSender = packetSender;
    }

    public static SkillsClientMod getInstance() {
        return instance;
    }

    public static void setup(ClientEventReceiver eventReceiver, KeyBindingReceiver keyBindingReceiver, ClientPacketSender packetSender, ClientPacketReceiver packetReceiver) {
        instance = new SkillsClientMod(packetSender);
        keyBindingReceiver.registerKeyBinding(OPEN_KEY_BINDING, instance::onOpenKeyPress);
        packetReceiver.registerPacket(Packets.SHOW_CATEGORY, ShowCategoryInPacket::read, instance::onShowCategory);
        packetReceiver.registerPacket(Packets.HIDE_CATEGORY, HideCategoryInPacket::read, instance::onHideCategory);
        packetReceiver.registerPacket(Packets.SKILL_UPDATE, SkillUpdateInPacket::read, instance::onSkillUpdatePacket);
        packetReceiver.registerPacket(Packets.POINTS_UPDATE, PointsUpdateInPacket::read, instance::onPointsUpdatePacket);
        packetReceiver.registerPacket(Packets.EXPERIENCE_UPDATE, ExperienceUpdateInPacket::read, instance::onExperienceUpdatePacket);
        packetReceiver.registerPacket(Packets.INVALID_CONFIG, InvalidConfigInPacket::read, instance::onInvalidConfig);
        eventReceiver.registerListener(instance.new EventListener());
    }

    private void onOpenKeyPress() {
        class_310.method_1551().method_1507((class_437)new SkillsScreen(this.categories));
    }

    private void onShowCategory(ShowCategoryInPacket packet) {
        ClientSkillCategoryData category = packet.getCategory();
        this.categories.put(category.getId(), category);
    }

    private void onHideCategory(HideCategoryInPacket packet) {
        this.categories.remove(packet.getCategoryId());
    }

    private void onSkillUpdatePacket(SkillUpdateInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> {
            if (packet.isUnlocked()) {
                category.unlock(packet.getSkillId());
            } else {
                category.lock(packet.getSkillId());
            }
        });
    }

    private void onExperienceUpdatePacket(ExperienceUpdateInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> {
            category.setCurrentLevel(packet.getCurrentLevel());
            category.setCurrentExperience(packet.getCurrentExperience());
            category.setRequiredExperience(packet.getRequiredExperience());
        });
    }

    private void onPointsUpdatePacket(PointsUpdateInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> {
            int oldPointsLeft = category.getPointsLeft();
            category.setSpentPoints(packet.getSpentPoints());
            category.setEarnedPoints(packet.getEarnedPoints());
            int newPointsLeft = category.getPointsLeft();
            if (packet.announceNewPoints() && newPointsLeft > oldPointsLeft && category.hasAvailableSkill()) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)SkillsMod.createTranslatable("chat", "new_point", OPEN_KEY_BINDING.method_16007()));
            }
        });
    }

    private void onInvalidConfig(InvalidConfigInPacket packet) {
        class_310 client = class_310.method_1551();
        client.method_1566().method_1999((class_368)SimpleToast.create(client, (class_2561)class_2561.method_43470((String)"Pufferfish's Skills"), (class_2561)class_2561.method_43471((String)"toast.puffish_skills.invalid_config.description")));
    }

    private Optional<ClientSkillCategoryData> getCategoryById(class_2960 categoryId) {
        return Optional.ofNullable(this.categories.get(categoryId));
    }

    public ClientPacketSender getPacketSender() {
        return this.packetSender;
    }

    private class EventListener
    implements ClientEventListener {
        private EventListener() {
        }

        @Override
        public void onPlayerJoin() {
            SkillsClientMod.this.categories.clear();
        }
    }
}

