/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.utils;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Result<S, F> {
    public static <S, R> Result<S, R> success(S s) {
        return new Success(s);
    }

    public static <L, F> Result<L, F> failure(F f) {
        return new Failure(f);
    }

    public Optional<S> getSuccess();

    public Optional<F> getFailure();

    public S getSuccessOrElse(Function<F, S> var1);

    public F getFailureOrElse(Function<S, F> var1);

    public void peek(Consumer<S> var1, Consumer<F> var2);

    public Result<S, F> ifSuccess(Consumer<S> var1);

    public Result<S, F> ifFailure(Consumer<F> var1);

    public <L2> Result<L2, F> mapSuccess(Function<S, L2> var1);

    public <F2> Result<S, F2> mapFailure(Function<F, F2> var1);

    public <S2> Result<S2, F> andThen(Function<S, Result<S2, F>> var1);

    public <F2> Result<S, F2> orElse(Function<F, Result<S, F2>> var1);

    public static final class Success<S, F>
    implements Result<S, F> {
        private final S s;

        private Success(S l) {
            this.s = l;
        }

        public S get() {
            return this.s;
        }

        @Override
        public Optional<S> getSuccess() {
            return Optional.of(this.s);
        }

        @Override
        public Optional<F> getFailure() {
            return Optional.empty();
        }

        @Override
        public S getSuccessOrElse(Function<F, S> f) {
            return this.s;
        }

        @Override
        public F getFailureOrElse(Function<S, F> f) {
            return f.apply(this.s);
        }

        @Override
        public void peek(Consumer<S> lc, Consumer<F> rc) {
            lc.accept(this.s);
        }

        @Override
        public Result<S, F> ifSuccess(Consumer<S> c) {
            c.accept(this.s);
            return this;
        }

        @Override
        public Result<S, F> ifFailure(Consumer<F> c) {
            return this;
        }

        @Override
        public <L2> Result<L2, F> mapSuccess(Function<S, L2> f) {
            return Result.success(f.apply(this.s));
        }

        @Override
        public <R2> Result<S, R2> mapFailure(Function<F, R2> f) {
            return Result.success(this.s);
        }

        @Override
        public <S2> Result<S2, F> andThen(Function<S, Result<S2, F>> function) {
            return function.apply(this.s);
        }

        @Override
        public <F2> Result<S, F2> orElse(Function<F, Result<S, F2>> function) {
            return Result.success(this.s);
        }
    }

    public static final class Failure<S, F>
    implements Result<S, F> {
        private final F f;

        private Failure(F r) {
            this.f = r;
        }

        public F get() {
            return this.f;
        }

        @Override
        public Optional<S> getSuccess() {
            return Optional.empty();
        }

        @Override
        public Optional<F> getFailure() {
            return Optional.of(this.f);
        }

        @Override
        public S getSuccessOrElse(Function<F, S> f) {
            return f.apply(this.f);
        }

        @Override
        public F getFailureOrElse(Function<S, F> f) {
            return this.f;
        }

        @Override
        public void peek(Consumer<S> lc, Consumer<F> rc) {
            rc.accept(this.f);
        }

        @Override
        public Result<S, F> ifSuccess(Consumer<S> c) {
            return this;
        }

        @Override
        public Result<S, F> ifFailure(Consumer<F> c) {
            c.accept(this.f);
            return this;
        }

        @Override
        public <L2> Result<L2, F> mapSuccess(Function<S, L2> f) {
            return Result.failure(this.f);
        }

        @Override
        public <F2> Result<S, F2> mapFailure(Function<F, F2> f) {
            return Result.failure(f.apply(this.f));
        }

        @Override
        public <S2> Result<S2, F> andThen(Function<S, Result<S2, F>> function) {
            return Result.failure(this.f);
        }

        @Override
        public <F2> Result<S, F2> orElse(Function<F, Result<S, F2>> function) {
            return function.apply(this.f);
        }
    }
}

