/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.utils;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2105;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3518;
import net.minecraft.class_4559;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;

public class JsonParseUtils {
    public static Result<class_2960, Failure> parseIdentifier(JsonElementWrapper element) {
        try {
            return Result.success(new class_2960(class_3518.method_15287((JsonElement)element.getJson(), (String)"")));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid identifier"));
        }
    }

    public static Result<String, Failure> parseIdentifierPath(JsonElementWrapper element) {
        try {
            return Result.success(new class_2960("minecraft", class_3518.method_15287((JsonElement)element.getJson(), (String)"")).method_12832());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid identifier path"));
        }
    }

    public static Result<class_1291, Failure> parseEffect(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_1291)class_7923.field_41174.method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid effect"));
        }
    }

    public static Result<class_2248, Failure> parseBlock(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid block"));
        }
    }

    public static Result<class_4559, Failure> parseStatePredicate(JsonElementWrapper element) {
        try {
            return Result.success(class_4559.method_22519((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid state predicate"));
        }
    }

    public static Result<class_2105, Failure> parseNbtPredicate(JsonElementWrapper element) {
        try {
            return Result.success(class_2105.method_9073((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid state predicate"));
        }
    }

    public static Result<class_6885.class_6888<class_2248>, Failure> parseBlockTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_6885.class_6888)class_7923.field_41175.method_46772().method_46733(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid block tag"));
        }
    }

    public static Result<class_8110, Failure> parseDamageType(JsonElementWrapper element, class_5455 manager) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_8110)manager.method_30530(class_7924.field_42534).method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid damage type"));
        }
    }

    public static Result<class_6885.class_6888<class_8110>, Failure> parseDamageTypeTag(JsonElementWrapper element, class_5455 manager) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_6885.class_6888)manager.method_30530(class_7924.field_42534).method_46772().method_46733(class_6862.method_40092((class_5321)class_7924.field_42534, (class_2960)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid damage type tag"));
        }
    }

    public static Result<class_1299<?>, Failure> parseEntityType(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_1299)class_7923.field_41177.method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid entity type"));
        }
    }

    public static Result<class_6885.class_6888<class_1299<?>>, Failure> parseEntityTypeTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_6885.class_6888)class_7923.field_41177.method_46772().method_46733(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid entity type tag"));
        }
    }

    public static Result<class_3445<?>, Failure> parseStat(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> JsonParseUtils.getOrCreateStat((class_3448)class_7923.field_41193.method_17966(class_2960.method_12838((String)id.method_12836(), (char)'.')).orElseThrow(), class_2960.method_12838((String)id.method_12832(), (char)'.')));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid statistic"));
        }
    }

    private static <T> class_3445<T> getOrCreateStat(class_3448<T> statType, class_2960 id) {
        return statType.method_14956(statType.method_14959().method_17966(id).orElseThrow());
    }

    public static Result<class_1792, Failure> parseItem(JsonElementWrapper element) {
        try {
            return Result.success(class_3518.method_15256((JsonElement)element.getJson(), (String)""));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid item"));
        }
    }

    public static Result<class_6885.class_6888<class_1792>, Failure> parseItemTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_6885.class_6888)class_7923.field_41178.method_46772().method_46733(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid item tag"));
        }
    }

    public static Result<class_2487, Failure> parseNbt(JsonElementWrapper element) {
        try {
            return Result.success(class_2522.method_10718((String)class_3518.method_15287((JsonElement)element.getJson(), (String)"")));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid nbt"));
        }
    }

    public static Result<class_1799, Failure> parseItemStack(JsonElementWrapper element) {
        try {
            return element.getAsObject().andThen(object -> {
                ArrayList<Failure> failures = new ArrayList<Failure>();
                Optional item = object.get("item").andThen(JsonParseUtils::parseItem).ifFailure(failures::add).getSuccess();
                Optional nbt = object.get("nbt").getSuccess().flatMap(nbtElement -> JsonParseUtils.parseNbt(nbtElement).ifFailure(failures::add).getSuccess());
                if (failures.isEmpty()) {
                    class_1799 itemStack = new class_1799((class_1935)item.orElseThrow());
                    nbt.ifPresent(arg_0 -> ((class_1799)itemStack).method_7980(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(Failure.fromMany(failures));
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid item stack"));
        }
    }

    public static Result<class_189, Failure> parseFrame(JsonElementWrapper element) {
        try {
            return element.getAsString().andThen(name -> Result.success(class_189.method_833((String)name)));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid frame"));
        }
    }

    public static Result<class_2561, Failure> parseText(JsonElementWrapper element) {
        try {
            return Result.success(class_2561.class_2562.method_10872((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid text"));
        }
    }

    public static Result<class_1320, Failure> parseAttribute(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_1320)class_7923.field_41190.method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createFailure("Expected valid attribute"));
        }
    }

    public static Result<class_1322.class_1323, Failure> parseAttributeOperation(JsonElementWrapper element) {
        return element.getAsString().andThen(string -> switch (string) {
            case "addition" -> Result.success(class_1322.class_1323.field_6328);
            case "multiply_base" -> Result.success(class_1322.class_1323.field_6330);
            case "multiply_total" -> Result.success(class_1322.class_1323.field_6331);
            default -> Result.failure(element.getPath().createFailure("Expected valid attribute operation"));
        });
    }
}

