/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.experience.ExperienceSource;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.commands.CategoryCommand;
import net.puffish.skillsmod.commands.ExperienceCommand;
import net.puffish.skillsmod.commands.PointsCommand;
import net.puffish.skillsmod.commands.SkillsCommand;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.ModConfig;
import net.puffish.skillsmod.config.PackConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.config.reader.FileConfigReader;
import net.puffish.skillsmod.config.reader.PackConfigReader;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.experience.builtin.CraftItemExperienceSource;
import net.puffish.skillsmod.experience.builtin.EatFoodExperienceSource;
import net.puffish.skillsmod.experience.builtin.IncreaseStatExperienceSource;
import net.puffish.skillsmod.experience.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.builtin.MineBlockExperienceSource;
import net.puffish.skillsmod.experience.builtin.TakeDamageExperienceSource;
import net.puffish.skillsmod.impl.config.ConfigContextImpl;
import net.puffish.skillsmod.impl.rewards.RewardContextImpl;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.rewards.builtin.AttributeReward;
import net.puffish.skillsmod.rewards.builtin.CommandReward;
import net.puffish.skillsmod.rewards.builtin.ScoreboardReward;
import net.puffish.skillsmod.rewards.builtin.TagReward;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.server.data.PlayerData;
import net.puffish.skillsmod.server.data.ServerData;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketReceiver;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.network.packets.in.SkillClickInPacket;
import net.puffish.skillsmod.server.network.packets.out.ExperienceUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.HideCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.InvalidConfigOutPacket;
import net.puffish.skillsmod.server.network.packets.out.PointsUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.SkillUpdateOutPacket;
import net.puffish.skillsmod.server.setup.ServerRegistrar;
import net.puffish.skillsmod.server.setup.SkillsArgumentTypes;
import net.puffish.skillsmod.server.setup.SkillsAttributes;
import net.puffish.skillsmod.server.setup.SkillsGameRules;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.ChangeListener;
import net.puffish.skillsmod.utils.PathUtils;
import net.puffish.skillsmod.utils.PrefixedLogger;

public class SkillsMod {
    public static final int CONFIG_VERSION = 1;
    private static SkillsMod instance;
    private final PrefixedLogger logger = new PrefixedLogger("puffish_skills");
    private final Path modConfigDir;
    private final ServerPacketSender packetSender;
    private final ChangeListener<Optional<Map<class_2960, CategoryConfig>>> categories = new ChangeListener(Optional.empty(), () -> {});

    private SkillsMod(Path modConfigDir, ServerPacketSender packetSender) {
        this.modConfigDir = modConfigDir;
        this.packetSender = packetSender;
    }

    public static SkillsMod getInstance() {
        return instance;
    }

    public static void setup(Path configDir, ServerRegistrar registrar, ServerEventReceiver eventReceiver, ServerPacketSender packetSender, ServerPacketReceiver packetReceiver) {
        Path modConfigDir = configDir.resolve("puffish_skills");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        instance = new SkillsMod(modConfigDir, packetSender);
        packetReceiver.registerPacket(Packets.SKILL_CLICK, SkillClickInPacket::read, instance::onSkillClickPacket);
        eventReceiver.registerListener(instance.new EventListener());
        SkillsAttributes.register(registrar);
        SkillsGameRules.register(registrar);
        SkillsArgumentTypes.register(registrar);
        AttributeReward.register();
        CommandReward.register();
        ScoreboardReward.register();
        TagReward.register();
        MineBlockExperienceSource.register();
        KillEntityExperienceSource.register();
        EatFoodExperienceSource.register();
        CraftItemExperienceSource.register();
        TakeDamageExperienceSource.register();
        IncreaseStatExperienceSource.register();
    }

    public static class_2960 createIdentifier(String path) {
        return new class_2960("puffish_skills", path);
    }

    public static class_2960 convertIdentifier(class_2960 id) {
        if (id.method_12836().equals("minecraft")) {
            return SkillsMod.createIdentifier(id.method_12832());
        }
        return id;
    }

    public static class_5250 createTranslatable(String type, String path, Object ... args) {
        return class_2561.method_43469((String)class_156.method_646((String)type, (class_2960)SkillsMod.createIdentifier(path)), (Object[])args);
    }

    public static class_2960 createAttribute(String type, String name) {
        return SkillsMod.createIdentifier(type + "." + name);
    }

    public PrefixedLogger getLogger() {
        return this.logger;
    }

    private void copyConfigFromJar() {
        PathUtils.copyFileFromJar(Path.of("config", "config.json"), this.modConfigDir.resolve("config.json"));
        List<String> categories = List.of("combat", "mining");
        List<String> files = List.of("category.json", "definitions.json", "skills.json", "connections.json", "experience.json");
        for (String category : categories) {
            for (String file : files) {
                PathUtils.copyFileFromJar(Path.of("config", "categories", category, file), this.modConfigDir.resolve(Path.of("categories", category, file)));
            }
        }
    }

    private void loadModConfig(MinecraftServer server) {
        if (!Files.exists(this.modConfigDir, new LinkOption[0]) || PathUtils.isDirectoryEmpty(this.modConfigDir)) {
            this.copyConfigFromJar();
        }
        FileConfigReader reader = new FileConfigReader(this.modConfigDir);
        LinkedHashMap cumulatedMap = new LinkedHashMap();
        reader.read(Path.of("config.json", new String[0])).andThen(ModConfig::parse).andThen(modConfig -> this.loadConfig(reader, (ModConfig)modConfig, server).mapSuccess(map -> {
            cumulatedMap.putAll(map);
            return modConfig;
        })).peek(modConfig -> {
            cumulatedMap.putAll(this.loadPackConfig((ModConfig)modConfig, server));
            this.categories.set(Optional.of(cumulatedMap), () -> {
                for (CategoryConfig category : cumulatedMap.values()) {
                    category.dispose(server);
                }
            });
        }, failure -> {
            this.logger.error("Configuration could not be loaded:" + System.lineSeparator() + failure.getMessages().stream().collect(Collectors.joining(System.lineSeparator())));
            this.categories.set(Optional.empty(), () -> {});
        });
    }

    private Result<Map<class_2960, CategoryConfig>, Failure> loadConfig(ConfigReader reader, ModConfig modConfig, MinecraftServer server) {
        ConfigContextImpl context = new ConfigContextImpl(server);
        return reader.readCategories("puffish_skills", modConfig.getCategories(), context).ifSuccess(map -> {
            if (modConfig.getShowWarnings() && !context.warnings().isEmpty()) {
                this.logger.warn("Configuration loaded successfully with warning(s):" + System.lineSeparator() + context.warnings().stream().collect(Collectors.joining(System.lineSeparator())));
            } else {
                this.logger.info("Configuration loaded successfully!");
            }
        });
    }

    private Map<class_2960, CategoryConfig> loadPackConfig(ModConfig modConfig, MinecraftServer server) {
        ConfigContextImpl context = new ConfigContextImpl(server);
        LinkedHashMap<class_2960, CategoryConfig> cumulatedMap = new LinkedHashMap<class_2960, CategoryConfig>();
        Map resources = context.getResourceManager().method_14488("puffish_skills", id -> id.method_12832().endsWith("config.json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_3298 resource = (class_3298)entry.getValue();
            class_2960 id2 = (class_2960)entry.getKey();
            String name = id2.method_12836();
            PackConfigReader reader = new PackConfigReader(context.getResourceManager(), name);
            reader.readResource(id2, resource).andThen(rootElement -> PackConfig.parse(name, rootElement)).andThen(packConfig -> reader.readCategories(name, packConfig.getCategories(), context)).peek(map -> {
                if (modConfig.getShowWarnings() && !context.warnings().isEmpty()) {
                    this.logger.warn("Data pack `" + name + "` loaded successfully with warning(s):" + System.lineSeparator() + context.warnings().stream().collect(Collectors.joining(System.lineSeparator())));
                } else {
                    this.logger.info("Data pack `" + name + "` loaded successfully!");
                }
                cumulatedMap.putAll((Map<class_2960, CategoryConfig>)map);
            }, failure -> this.logger.error("Data pack `" + name + "` could not be loaded:" + System.lineSeparator() + failure.getMessages().stream().collect(Collectors.joining(System.lineSeparator()))));
        }
        return cumulatedMap;
    }

    private void onSkillClickPacket(class_3222 player, SkillClickInPacket packet) {
        if (player.method_7325()) {
            return;
        }
        this.tryUnlockSkill(player, packet.getCategoryId(), packet.getSkillId(), false);
    }

    public void unlockSkill(class_3222 player, class_2960 categoryId, String skillId) {
        this.tryUnlockSkill(player, categoryId, skillId, true);
    }

    private void tryUnlockSkill(class_3222 player, class_2960 categoryId, String skillId, boolean force) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            if (categoryData.tryUnlockSkill((CategoryConfig)category, player, skillId, force)) {
                this.packetSender.send(player, SkillUpdateOutPacket.write(categoryId, skillId, true));
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            }
        }));
    }

    public void lockSkill(class_3222 player, class_2960 categoryId, String skillId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.lockSkill(skillId);
            this.packetSender.send(player, SkillUpdateOutPacket.write(categoryId, skillId, false));
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void resetSkills(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.resetSkills();
            this.applyRewards(player, (CategoryConfig)category, (CategoryData)categoryData);
            this.syncCategory(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void eraseCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.removeCategoryData((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void unlockCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.unlockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void lockCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.lockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public Optional<Boolean> hasExperience(class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> category.getExperience().isPresent());
    }

    public void addExperience(class_3222 player, class_2960 categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (category.getExperience().isEmpty()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.addExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public void setExperience(class_3222 player, class_2960 categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (category.getExperience().isEmpty()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.setEarnedExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public Optional<Integer> getExperience(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).flatMap(category -> {
            if (category.getExperience().isEmpty()) {
                return Optional.empty();
            }
            return this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getEarnedExperience);
        });
    }

    public void addExtraPoints(class_3222 player, class_2960 categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.addExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void setExtraPoints(class_3222 player, class_2960 categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.setExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public Optional<Integer> getExtraPoints(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).flatMap(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getExtraPoints));
    }

    public Optional<Integer> getPointsLeft(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getPointsLeft((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentLevel(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getCurrentLevel((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentExperience(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getCurrentExperience((CategoryConfig)category);
        });
    }

    public Optional<Integer> getRequiredExperience(class_3222 player, class_2960 categoryId, int level) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getRequiredExperience((CategoryConfig)category, level);
        });
    }

    public Optional<Integer> getRequiredTotalExperience(class_3222 player, class_2960 categoryId, int level) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getRequiredTotalExperience((CategoryConfig)category, level);
        });
    }

    public Optional<SkillState> getSkillState(class_3222 player, class_2960 categoryId, String skillId) {
        return this.getCategory(categoryId).flatMap(category -> category.getSkills().getById(skillId).map(skill -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getSkillState((CategoryConfig)category, (SkillConfig)skill);
        }));
    }

    public Collection<class_2960> getUnlockedCategories(class_3222 player) {
        PlayerData playerData = this.getPlayerData(player);
        return this.getAllCategories().stream().filter(playerData::isCategoryUnlocked).map(CategoryConfig::getId).toList();
    }

    public Collection<class_2960> getCategories(boolean onlyWithExperience) {
        return this.getAllCategories().stream().filter(category -> !onlyWithExperience || category.getExperience().isPresent()).map(CategoryConfig::getId).toList();
    }

    public Optional<Collection<String>> getUnlockedSkills(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getUnlockedSkillIds();
        });
    }

    public Optional<Collection<String>> getSkills(class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getAll().stream().map(SkillConfig::getId).toList());
    }

    public boolean hasCategory(class_2960 categoryId) {
        return this.getCategory(categoryId).isPresent();
    }

    public boolean hasSkill(class_2960 categoryId, String skillId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getById(skillId).isPresent()).orElse(false);
    }

    private void showCategory(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, ShowCategoryOutPacket.write(category, categoryData));
    }

    private void hideCategory(class_3222 player, CategoryConfig category) {
        this.packetSender.send(player, HideCategoryOutPacket.write(category.getId()));
    }

    private void syncPoints(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, PointsUpdateOutPacket.write(category.getId(), categoryData.getSpentPoints(category), categoryData.getEarnedPoints(category), player.method_37908().method_8450().method_8355(SkillsGameRules.ANNOUNCE_NEW_POINTS)));
    }

    private void syncExperience(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        int level = categoryData.getCurrentLevel(category);
        this.packetSender.send(player, ExperienceUpdateOutPacket.write(category.getId(), level, categoryData.getCurrentExperience(category), categoryData.getRequiredExperience(category, level)));
    }

    public void refreshReward(class_3222 player, class_2960 type) {
        for (CategoryConfig category : this.getAllCategories()) {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData(category);
            categoryData.refreshReward(category, player, type);
        }
    }

    public void visitExperienceSources(class_3222 player, Function<ExperienceSource, Integer> function) {
        for (CategoryConfig category : this.getAllCategories()) {
            category.getExperience().ifPresent(experience -> this.getCategoryDataIfUnlocked(player, category).ifPresent(categoryData -> {
                int amount = 0;
                for (ExperienceSourceConfig experienceSource : experience.getExperienceSources()) {
                    amount += ((Integer)function.apply(experienceSource.getInstance())).intValue();
                }
                if (amount != 0) {
                    categoryData.addExperience(amount);
                    this.syncExperience(player, category, (CategoryData)categoryData);
                    this.syncPoints(player, category, (CategoryData)categoryData);
                }
            }));
        }
    }

    private void applyRewards(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        categoryData.applyRewards(category, player);
    }

    private void resetRewards(class_3222 player, CategoryConfig category) {
        for (SkillDefinitionConfig definition : category.getDefinitions().getAll()) {
            for (SkillRewardConfig reward : definition.getRewards()) {
                reward.getInstance().update(player, new RewardContextImpl(0, false));
            }
        }
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(class_3222 player, CategoryConfig category) {
        return this.getCategoryDataIfUnlocked(this.getPlayerData(player), category);
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(PlayerData playerData, CategoryConfig category) {
        if (playerData.isCategoryUnlocked(category)) {
            return Optional.of(playerData.getCategoryData(category));
        }
        return Optional.empty();
    }

    private Optional<CategoryConfig> getCategory(class_2960 categoryId) {
        return this.categories.get().flatMap(map -> Optional.ofNullable((CategoryConfig)map.get(categoryId)));
    }

    private Collection<CategoryConfig> getAllCategories() {
        return this.categories.get().map(Map::values).orElseGet(Collections::emptyList);
    }

    private void syncCategory(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        this.applyRewards(player, category, categoryData);
        this.showCategory(player, category, categoryData);
    }

    private void syncCategory(class_3222 player, CategoryConfig category) {
        this.getCategoryDataIfUnlocked(player, category).ifPresentOrElse(categoryData -> this.syncCategory(player, category, (CategoryData)categoryData), () -> {
            this.resetRewards(player, category);
            this.hideCategory(player, category);
        });
    }

    private void syncAllCategories(class_3222 player) {
        if (this.isConfigValid()) {
            for (CategoryConfig category : this.getAllCategories()) {
                this.syncCategory(player, category);
            }
        } else if (this.isPlayerOperator(player)) {
            this.packetSender.send(player, InvalidConfigOutPacket.write());
        }
    }

    private boolean isConfigValid() {
        return this.categories.get().isPresent();
    }

    private PlayerData getPlayerData(class_3222 player) {
        return ServerData.getOrCreate(this.getPlayerServer(player)).getPlayerData(player);
    }

    private MinecraftServer getPlayerServer(class_3222 player) {
        return Objects.requireNonNull(player.method_5682());
    }

    private boolean isPlayerOperator(class_3222 player) {
        return this.getPlayerServer(player).method_3760().method_14569(player.method_7334());
    }

    private class EventListener
    implements ServerEventListener {
        private EventListener() {
        }

        @Override
        public void onServerStarting(MinecraftServer server) {
            SkillsMod.this.loadModConfig(server);
        }

        @Override
        public void onServerReload(MinecraftServer server) {
            for (class_3222 player : server.method_3760().method_14571()) {
                for (CategoryConfig category : SkillsMod.this.getAllCategories()) {
                    SkillsMod.this.hideCategory(player, category);
                }
            }
            SkillsMod.this.loadModConfig(server);
            for (class_3222 player : server.method_3760().method_14571()) {
                SkillsMod.this.syncAllCategories(player);
            }
        }

        @Override
        public void onPlayerJoin(class_3222 player) {
            SkillsMod.this.syncAllCategories(player);
        }

        @Override
        public void onCommandsRegister(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"puffish_skills").then(CategoryCommand.create())).then(SkillsCommand.create())).then(PointsCommand.create())).then(ExperienceCommand.create()));
        }
    }
}

