/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.json;

import com.google.gson.JsonElement;
import net.puffish.skillsmod.api.json.JsonArrayWrapper;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.impl.json.JsonArrayWrapperImpl;
import net.puffish.skillsmod.impl.json.JsonObjectWrapperImpl;
import net.puffish.skillsmod.impl.json.JsonWrapperImpl;

public class JsonElementWrapperImpl
extends JsonWrapperImpl
implements JsonElementWrapper {
    private final JsonElement json;

    public JsonElementWrapperImpl(JsonElement json, JsonPath path) {
        super(path);
        this.json = json;
    }

    @Override
    public Result<JsonObjectWrapper, Failure> getAsObject() {
        try {
            return Result.success(new JsonObjectWrapperImpl(this.json.getAsJsonObject(), this.path));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an object"));
        }
    }

    @Override
    public Result<JsonArrayWrapper, Failure> getAsArray() {
        try {
            return Result.success(new JsonArrayWrapperImpl(this.json.getAsJsonArray(), this.path));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an array"));
        }
    }

    @Override
    public Result<String, Failure> getAsString() {
        try {
            return Result.success(this.json.getAsString());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a string"));
        }
    }

    @Override
    public Result<Float, Failure> getAsFloat() {
        try {
            return Result.success(Float.valueOf(this.json.getAsFloat()));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a float"));
        }
    }

    @Override
    public Result<Double, Failure> getAsDouble() {
        try {
            return Result.success(this.json.getAsDouble());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a double"));
        }
    }

    @Override
    public Result<Integer, Failure> getAsInt() {
        try {
            return Result.success(this.json.getAsInt());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an int"));
        }
    }

    @Override
    public Result<Boolean, Failure> getAsBoolean() {
        try {
            return Result.success(this.json.getAsBoolean());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a boolean"));
        }
    }

    @Override
    public JsonElement getJson() {
        return this.json;
    }
}

