/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.expression;

import java.util.List;
import java.util.Set;
import net.minecraft.class_3532;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.expression.BinaryOperator;
import net.puffish.skillsmod.expression.Expression;
import net.puffish.skillsmod.expression.FunctionOperator;
import net.puffish.skillsmod.expression.GroupOperator;
import net.puffish.skillsmod.expression.Parser;
import net.puffish.skillsmod.expression.UnaryOperator;

public class ArithmeticParser {
    private static final List<BinaryOperator<Double>> ARITHMETIC_BINARY = List.of(BinaryOperator.createLeft("+", 1, (l, r) -> v -> (Double)l.eval(v) + (Double)r.eval(v)), BinaryOperator.createLeft("-", 1, (l, r) -> v -> (Double)l.eval(v) - (Double)r.eval(v)), BinaryOperator.createLeft("*", 2, (l, r) -> v -> (Double)l.eval(v) * (Double)r.eval(v)), BinaryOperator.createLeft("/", 2, (l, r) -> v -> (Double)l.eval(v) / (Double)r.eval(v)), BinaryOperator.createRight("^", 4, (l, r) -> v -> Math.pow((Double)l.eval(v), (Double)r.eval(v))));
    private static final List<UnaryOperator<Double>> ARITHMETIC_UNARY = List.of(UnaryOperator.create("+", 3, e -> v -> (double)((Double)e.eval(v))), UnaryOperator.create("-", 3, e -> v -> -((Double)e.eval(v)).doubleValue()));
    private static final List<GroupOperator> ARITHMETIC_GROUP = List.of(GroupOperator.create("(", ")"));
    private static final List<FunctionOperator<Double>> ARITHMETIC_FUNCTION = List.of(FunctionOperator.create("sin", "(", ",", ")", 1, l -> v -> Math.sin((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("cos", "(", ",", ")", 1, l -> v -> Math.cos((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("tan", "(", ",", ")", 1, l -> v -> Math.tan((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("asin", "(", ",", ")", 1, l -> v -> Math.asin((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("acos", "(", ",", ")", 1, l -> v -> Math.acos((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("atan", "(", ",", ")", 1, l -> v -> Math.atan((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("atan2", "(", ",", ")", 2, l -> v -> Math.atan2((Double)((Expression)l.get(0)).eval(v), (Double)((Expression)l.get(1)).eval(v))), FunctionOperator.create("sinh", "(", ",", ")", 1, l -> v -> Math.sinh((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("cosh", "(", ",", ")", 1, l -> v -> Math.cosh((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("tanh", "(", ",", ")", 1, l -> v -> Math.tanh((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("log", "(", ",", ")", 1, l -> v -> Math.log((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("exp", "(", ",", ")", 1, l -> v -> Math.exp((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("sqrt", "(", ",", ")", 1, l -> v -> Math.sqrt((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("cbrt", "(", ",", ")", 1, l -> v -> Math.cbrt((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("floor", "(", ",", ")", 1, l -> v -> Math.floor((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("ceil", "(", ",", ")", 1, l -> v -> Math.ceil((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("round", "(", ",", ")", 1, l -> v -> Math.round((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("trunc", "(", ",", ")", 1, l -> v -> ((Double)((Expression)l.get(0)).eval(v)).longValue()), FunctionOperator.create("abs", "(", ",", ")", 1, l -> v -> Math.abs((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("sign", "(", ",", ")", 1, l -> v -> Math.signum((Double)((Expression)l.get(0)).eval(v))), FunctionOperator.create("fract", "(", ",", ")", 1, l -> v -> class_3532.method_15385((double)((Double)((Expression)l.get(0)).eval(v)))), FunctionOperator.create("mod", "(", ",", ")", 2, l -> v -> class_3532.method_15367((double)((Double)((Expression)l.get(0)).eval(v)), (double)((Double)((Expression)l.get(1)).eval(v)))), FunctionOperator.create("mix", "(", ",", ")", 3, l -> v -> class_3532.method_16436((double)((Double)((Expression)l.get(2)).eval(v)), (double)((Double)((Expression)l.get(0)).eval(v)), (double)((Double)((Expression)l.get(1)).eval(v)))), FunctionOperator.create("clamp", "(", ",", ")", 3, l -> v -> class_3532.method_15350((double)((Double)((Expression)l.get(0)).eval(v)), (double)((Double)((Expression)l.get(1)).eval(v)), (double)((Double)((Expression)l.get(2)).eval(v)))), FunctionOperator.createVariadic("min", "(", ",", ")", l -> v -> l.stream().mapToDouble(e -> (Double)e.eval(v)).min().orElse(Double.MAX_VALUE)), FunctionOperator.createVariadic("max", "(", ",", ")", l -> v -> l.stream().mapToDouble(e -> (Double)e.eval(v)).max().orElse(-1.7976931348623157E308)));

    public static Result<Expression<Double>, Failure> parse(String expression, Set<String> variables) {
        return Parser.parse(expression, ARITHMETIC_UNARY, ARITHMETIC_BINARY, ARITHMETIC_GROUP, ARITHMETIC_FUNCTION, token -> {
            if (variables.contains(token)) {
                return Result.success(v -> (Double)v.get(token));
            }
            try {
                double value = Double.parseDouble(token);
                return Result.success(v -> value);
            }
            catch (Exception e) {
                return Result.failure(Failure.message("Unknown variable `" + token + "`"));
            }
        });
    }
}

