/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.builtin;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.ExperienceSource;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.experience.calculation.condition.DamageTypeCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.DamageTypeTagCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.EntityTypeCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.EntityTypeTagCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.ItemCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.ItemNbtCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.ItemTagCondition;
import net.puffish.skillsmod.api.experience.calculation.parameter.AttributeParameter;
import net.puffish.skillsmod.api.experience.calculation.parameter.EffectParameter;
import net.puffish.skillsmod.api.experience.calculation.parameter.ParameterFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.experience.calculation.CalculationManager;

public class KillEntityExperienceSource
implements ExperienceSource {
    public static final class_2960 ID = SkillsMod.createIdentifier("kill_entity");
    private static final Map<String, ConditionFactory<Context>> CONDITIONS = Map.ofEntries(Map.entry("entity", EntityTypeCondition.factory().map(c -> c.map(Context::entityType))), Map.entry("entity_tag", EntityTypeTagCondition.factory().map(c -> c.map(Context::entityType))), Map.entry("weapon", ItemCondition.factory().map(c -> c.map(Context::weapon))), Map.entry("weapon_nbt", ItemNbtCondition.factory().map(c -> c.map(Context::weapon))), Map.entry("weapon_tag", ItemTagCondition.factory().map(c -> c.map(Context::weapon))), Map.entry("damage_type", DamageTypeCondition.factory().map(c -> c.map(Context::damageType))), Map.entry("damage_type_tag", DamageTypeTagCondition.factory().map(c -> c.map(Context::damageType))));
    private static final Map<String, ParameterFactory<Context>> PARAMETERS = Map.ofEntries(Map.entry("player_effect", EffectParameter.factory().map(p -> p.map(Context::player))), Map.entry("player_attribute", AttributeParameter.factory().map(p -> p.map(Context::player))), Map.entry("entity_dropped_experience", ParameterFactory.simple(Context::entityDroppedXp)), Map.entry("entity_max_health", ParameterFactory.simple(Context::entityMaxHealth)));
    private final CalculationManager<Context> manager;
    private final Optional<AntiFarming> optAntiFarming;

    private KillEntityExperienceSource(CalculationManager<Context> calculated, Optional<AntiFarming> optAntiFarming) {
        this.manager = calculated;
        this.optAntiFarming = optAntiFarming;
    }

    public static void register() {
        SkillsAPI.registerExperienceSourceWithData(ID, (json, context) -> json.getAsObject().andThen(rootObject -> KillEntityExperienceSource.create(rootObject, context)));
    }

    private static Result<KillEntityExperienceSource, Failure> create(JsonObjectWrapper rootObject, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optCalculated = CalculationManager.create(rootObject, CONDITIONS, PARAMETERS, context).ifFailure(failures::add).getSuccess();
        Optional<AntiFarming> optAntiFarming = rootObject.get("anti_farming").getSuccess().flatMap(element -> AntiFarming.parse(element).ifFailure(failures::add).getSuccess().flatMap(Function.identity()));
        if (failures.isEmpty()) {
            return Result.success(new KillEntityExperienceSource(optCalculated.orElseThrow(), optAntiFarming));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    public int getValue(class_3222 player, class_1309 entity, class_1799 weapon, class_1282 damageSource, double entityDroppedXp) {
        return this.manager.getValue(new Context(player, entity, weapon, damageSource, entityDroppedXp));
    }

    public Optional<AntiFarming> getAntiFarming() {
        return this.optAntiFarming;
    }

    @Override
    public void dispose(MinecraftServer server) {
    }

    private record Context(class_3222 player, class_1309 entity, class_1799 weapon, class_1282 damageSource, double entityDroppedXp) {
        public double entityMaxHealth() {
            return this.entity.method_6063();
        }

        public class_1299<?> entityType() {
            return this.entity.method_5864();
        }

        class_6880<class_8110> damageType() {
            return this.damageSource.method_48793();
        }
    }

    public record AntiFarming(int limitPerChunk, int resetAfterSeconds) {
        public static Result<Optional<AntiFarming>, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(AntiFarming::parse);
        }

        public static Result<Optional<AntiFarming>, Failure> parse(JsonObjectWrapper rootObject) {
            ArrayList<Failure> failures = new ArrayList<Failure>();
            Boolean enabled = rootObject.getBoolean("enabled").getSuccess().orElse(true);
            Optional<Integer> optLimitPerChunk = rootObject.getInt("limit_per_chunk").ifFailure(failures::add).getSuccess();
            Optional<Integer> optResetAfterSeconds = rootObject.getInt("reset_after_seconds").ifFailure(failures::add).getSuccess();
            if (failures.isEmpty()) {
                if (enabled.booleanValue()) {
                    return Result.success(Optional.of(new AntiFarming(optLimitPerChunk.orElseThrow(), optResetAfterSeconds.orElseThrow())));
                }
                return Result.success(Optional.empty());
            }
            return Result.failure(Failure.fromMany(failures));
        }
    }
}

