/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonArrayWrapper;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.config.skill.SkillsConfig;

public class SkillConnectionConfig {
    private final String skillAId;
    private final String skillBId;

    private SkillConnectionConfig(String skillAId, String skillBId) {
        this.skillAId = skillAId;
        this.skillBId = skillBId;
    }

    public static Result<SkillConnectionConfig, Failure> parse(JsonElementWrapper rootElement, SkillsConfig skills) {
        return rootElement.getAsArray().andThen(rootArray -> SkillConnectionConfig.parse(rootArray, skills));
    }

    private static Result<SkillConnectionConfig, Failure> parse(JsonArrayWrapper rootArray, SkillsConfig skills) {
        if (rootArray.getSize() != 2) {
            return Result.failure(rootArray.getPath().createFailure("Expected an array of 2 elements"));
        }
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optIds = rootArray.getAsList((i, element) -> element.getAsString().andThen(id -> {
            if (skills.getById((String)id).isEmpty()) {
                return Result.failure(element.getPath().createFailure("Expected a valid skill"));
            }
            return Result.success(id);
        })).ifFailure(failures::addAll).getSuccess();
        if (failures.isEmpty()) {
            List ids = optIds.orElseThrow();
            return Result.success(new SkillConnectionConfig((String)ids.get(0), (String)ids.get(1)));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    public String getSkillAId() {
        return this.skillAId;
    }

    public String getSkillBId() {
        return this.skillBId;
    }
}

