/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;

public class IconConfig {
    private final String type;
    private final JsonElement data;

    private IconConfig(String type, JsonElement data) {
        this.type = type;
        this.data = data;
    }

    public static Result<IconConfig, Failure> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(IconConfig::parse);
    }

    public static Result<IconConfig, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<String> type = rootObject.getString("type").ifFailure(failures::add).getSuccess();
        Optional<JsonElementWrapper> data = rootObject.get("data").ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new IconConfig(type.orElseThrow(), data.orElseThrow().getJson()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    public String getType() {
        return this.type;
    }

    public JsonElement getData() {
        return this.data;
    }
}

