/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_189;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;

public class FrameConfig {
    private final String type;
    private final JsonElement data;

    private FrameConfig(String type, JsonElement data) {
        this.type = type;
        this.data = data;
    }

    public static FrameConfig fromAdvancementFrame(class_189 frame) {
        JsonObject data = new JsonObject();
        data.addProperty("frame", frame.method_831());
        return new FrameConfig("advancement", (JsonElement)data);
    }

    public static Result<FrameConfig, Failure> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(FrameConfig::parse);
    }

    public static Result<FrameConfig, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<String> type = rootObject.getString("type").ifFailure(failures::add).getSuccess();
        Optional<JsonElementWrapper> data = rootObject.get("data").ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new FrameConfig(type.orElseThrow(), data.orElseThrow().getJson()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    public String getType() {
        return this.type;
    }

    public JsonElement getData() {
        return this.data;
    }
}

