/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4fc;

public class TextureBatchedRenderer {
    private final Map<class_2960, List<TextureEmit>> batch = new HashMap<class_2960, List<TextureEmit>>();

    public void emitTexture(class_332 context, class_2960 texture, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public void emitTexture(class_332 context, class_2960 texture, int x, int y, int width, int height, float minU, float minV, float maxU, float maxV, Vector4fc color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, minU, minV, maxU, maxV, color);
    }

    public void emitSpriteStretch(class_332 context, class_1058 sprite, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, sprite.method_45852(), x, y, x + width, y + height, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575(), color);
    }

    private void emitTextureBatched(class_332 context, class_2960 texture, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, Vector4fc color) {
        List emits = this.batch.computeIfAbsent(texture, key -> new ArrayList());
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        Vector3f v1 = matrix.transformPosition(new Vector3f(minX, minY, 0.0f));
        Vector3f v2 = matrix.transformPosition(new Vector3f(minX, maxY, 0.0f));
        Vector3f v3 = matrix.transformPosition(new Vector3f(maxX, maxY, 0.0f));
        Vector3f v4 = matrix.transformPosition(new Vector3f(maxX, minY, 0.0f));
        emits.add(new TextureEmit(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z, v4.x, v4.y, v4.z, minU, minV, maxU, maxV, color));
    }

    public void draw() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34541);
        for (Map.Entry<class_2960, List<TextureEmit>> entry : this.batch.entrySet()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)entry.getKey());
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
            for (TextureEmit emit : entry.getValue()) {
                bufferBuilder.method_22912((double)emit.x1, (double)emit.y1, (double)emit.z1).method_22915(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).method_22913(emit.minU, emit.minV).method_1344();
                bufferBuilder.method_22912((double)emit.x2, (double)emit.y2, (double)emit.z2).method_22915(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).method_22913(emit.minU, emit.maxV).method_1344();
                bufferBuilder.method_22912((double)emit.x3, (double)emit.y3, (double)emit.z3).method_22915(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).method_22913(emit.maxU, emit.maxV).method_1344();
                bufferBuilder.method_22912((double)emit.x4, (double)emit.y4, (double)emit.z4).method_22915(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).method_22913(emit.maxU, emit.minV).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        this.batch.clear();
    }

    private record TextureEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float minU, float minV, float maxU, float maxV, Vector4fc color) {
    }
}

