/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.puffish.skillsmod.api.json.JsonArrayWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.json.JsonWrapper;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.impl.json.JsonElementWrapperImpl;

public interface JsonElementWrapper
extends JsonWrapper {
    public static Result<JsonElementWrapper, Failure> parseString(String jsonData, JsonPath jsonPath) {
        return JsonElementWrapper.parseReader(new StringReader(jsonData), jsonPath);
    }

    public static Result<JsonElementWrapper, Failure> parseReader(Reader reader, JsonPath jsonPath) {
        try {
            return Result.success(new JsonElementWrapperImpl(JsonParser.parseReader((Reader)reader), jsonPath));
        }
        catch (Exception e) {
            return Result.failure(jsonPath.createFailure("Could not parse JSON due to malformed syntax"));
        }
    }

    public static Result<JsonElementWrapper, Failure> parseFile(Path filePath, JsonPath jsonPath) {
        try {
            String content = Files.readString(filePath);
            if (content.isEmpty()) {
                return Result.failure(jsonPath.createFailure("File is empty"));
            }
            return JsonElementWrapper.parseString(content, jsonPath);
        }
        catch (Exception e) {
            return Result.failure(jsonPath.createFailure("Could not read file"));
        }
    }

    public Result<JsonObjectWrapper, Failure> getAsObject();

    public Result<JsonArrayWrapper, Failure> getAsArray();

    public Result<String, Failure> getAsString();

    public Result<Float, Failure> getAsFloat();

    public Result<Double, Failure> getAsDouble();

    public Result<Integer, Failure> getAsInt();

    public Result<Boolean, Failure> getAsBoolean();

    public JsonElement getJson();
}

