/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class MessageLoopcastSync {
    private final int entityId;
    private final byte loopcastState;

    public MessageLoopcastSync(int entityId, boolean isLoopcasting, Hand hand) {
        this.entityId = entityId;
        this.loopcastState = (byte)((isLoopcasting ? 1 : 0) | (hand == null ? 0 : hand.ordinal() << 1));
    }

    public MessageLoopcastSync(PacketBuffer buf) {
        this.entityId = buf.func_150792_a();
        this.loopcastState = buf.readByte();
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.entityId);
        buf.writeByte((int)this.loopcastState);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        boolean isLoopcasting;
        boolean bl = isLoopcasting = (this.loopcastState & 1) != 0;
        Hand loopcastHand = isLoopcasting ? ((this.loopcastState & 2) != 0 ? Hand.OFF_HAND : Hand.MAIN_HAND) : null;
        context.get().enqueueWork(() -> {
            PlayerEntity mcPlayer = Psi.proxy.getClientPlayer();
            if (mcPlayer == null) {
                return;
            }
            World world = mcPlayer.field_70170_p;
            Entity player = null;
            if (world != null) {
                player = world.func_73045_a(this.entityId);
            } else if (mcPlayer.func_145782_y() == this.entityId) {
                player = mcPlayer;
            }
            if (player instanceof PlayerEntity) {
                PlayerDataHandler.PlayerData data = PlayerDataHandler.get((PlayerEntity)player);
                data.loopcasting = isLoopcasting;
                data.loopcastHand = loopcastHand;
            }
        });
        return true;
    }
}

