/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.crafting.recipe.TrickRecipe;

public class DimensionTrickRecipe
extends TrickRecipe {
    public static final IRecipeSerializer<DimensionTrickRecipe> SERIALIZER = new Serializer();
    private final RegistryKey<World> dimensionKey;

    public DimensionTrickRecipe(ResourceLocation id, @Nullable PieceCraftingTrick piece, Ingredient input, ItemStack output, ItemStack cad, RegistryKey<World> dimensionKey) {
        super(id, piece, input, output, cad);
        this.dimensionKey = dimensionKey;
    }

    public DimensionTrickRecipe(ResourceLocation id, @Nullable PieceCraftingTrick piece, Ingredient input, ItemStack output, ItemStack cad, ResourceLocation dimensionKey) {
        this(id, piece, input, output, cad, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimensionKey));
    }

    @Override
    public boolean matches(RecipeWrapper inv, World world) {
        return super.matches(inv, world) && world.func_234923_W_() == this.dimensionKey;
    }

    @Override
    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DimensionTrickRecipe> {
        public DimensionTrickRecipe read(ResourceLocation id, JsonObject json) {
            TrickRecipe recipe = (TrickRecipe)TrickRecipe.SERIALIZER.func_199425_a_(id, json);
            ResourceLocation dimensionId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"dimension"));
            return new DimensionTrickRecipe(id, recipe.getPiece(), recipe.getInput(), recipe.func_77571_b(), recipe.getAssembly(), dimensionId);
        }

        @Nullable
        public DimensionTrickRecipe read(ResourceLocation id, PacketBuffer buf) {
            TrickRecipe recipe = (TrickRecipe)TrickRecipe.SERIALIZER.func_199426_a_(id, buf);
            ResourceLocation dimensionId = buf.func_192575_l();
            return new DimensionTrickRecipe(id, recipe.getPiece(), recipe.getInput(), recipe.func_77571_b(), recipe.getAssembly(), dimensionId);
        }

        public void write(PacketBuffer buf, DimensionTrickRecipe recipe) {
            TrickRecipe.SERIALIZER.func_199427_a_(buf, (IRecipe)recipe);
            buf.func_192572_a(recipe.dimensionKey.func_240901_a_());
        }
    }
}

