/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.helper;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class TextHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static List<String> renderText(int x, int y, int width, String unlocalizedText, boolean centered, boolean doit, Object ... format) {
        MatrixStack matrixStack = new MatrixStack();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String text = I18n.func_135052_a((String)unlocalizedText, (Object[])format);
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList();
        for (String string : textEntries) {
            ArrayList<String> words = new ArrayList<String>();
            String lineStr = "";
            String[] tokens = string.split(" ");
            for (String token : tokens) {
                String prev = lineStr;
                String spaced = token + " ";
                lineStr = lineStr + spaced;
                String controlCodes = TextHelper.toControlCodes(TextHelper.getControlCodes(prev));
                if (font.func_78256_a(lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + spaced;
                    words = new ArrayList();
                }
                words.add(controlCodes + token);
            }
            if (!lineStr.isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
        }
        ArrayList<String> textLines = new ArrayList<String>();
        String lastLine = "";
        for (List list : lines) {
            list.size();
            int xi = x;
            int spacing = 4;
            StringBuilder lineStr = new StringBuilder();
            for (String s : list) {
                int extra = 0;
                int swidth = font.func_78256_a(s);
                if (doit) {
                    if (centered) {
                        font.func_238421_b_(matrixStack, s, (float)(xi + width / 2 - swidth / 2), (float)y, 0xFFFFFF);
                    } else {
                        font.func_238421_b_(matrixStack, s, (float)xi, (float)y, 0xFFFFFF);
                    }
                }
                xi += swidth + spacing + extra;
                lineStr.append(s).append(" ");
            }
            if (lineStr.length() > 0 || lastLine.isEmpty()) {
                y += 10;
                textLines.add(lineStr.toString());
            }
            lastLine = lineStr.toString();
        }
        return textLines;
    }

    public static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        return controls.replaceAll(".*r", "r");
    }

    public static String toControlCodes(String s) {
        return s.replaceAll("(?i)[\\dA-FK-OR]", "\u00a7$0");
    }
}

