/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.ItemExosuitSensor;
import vazkii.psi.common.item.armor.ItemPsimetalArmor;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.item.component.ItemCADColorizer;

public class ColorHandler {
    public static void init() {
        ItemColors items = Minecraft.func_71410_x().getItemColors();
        items.func_199877_a((stack, tintIndex) -> tintIndex == 1 ? ((ItemPsimetalArmor)stack.func_77973_b()).getColor(stack) : 0xFFFFFF, new IItemProvider[]{ModItems.psimetalExosuitBoots, ModItems.psimetalExosuitChestplate, ModItems.psimetalExosuitHelmet, ModItems.psimetalExosuitLeggings});
        items.func_199877_a((stack, tintIndex) -> tintIndex == 1 ? ((ItemExosuitSensor)stack.func_77973_b()).getColor(stack) : 0xFFFFFF, new IItemProvider[]{ModItems.exosuitSensorHeat, ModItems.exosuitSensorLight, ModItems.exosuitSensorStress, ModItems.exosuitSensorWater, ModItems.exosuitSensorTrigger});
        items.func_199877_a((stack, tintIndex) -> tintIndex == 1 ? ((ItemCAD)stack.func_77973_b()).getSpellColor(stack) : 0xFFFFFF, new IItemProvider[]{ModItems.cad});
        items.func_199877_a((stack, tintIndex) -> tintIndex != 1 ? -1 : ((ItemCADColorizer)stack.func_77973_b()).getColor(stack), new IItemProvider[]{ModItems.cadColorizerWhite, ModItems.cadColorizerOrange, ModItems.cadColorizerMagenta, ModItems.cadColorizerLightBlue, ModItems.cadColorizerYellow, ModItems.cadColorizerLime, ModItems.cadColorizerPink, ModItems.cadColorizerGray, ModItems.cadColorizerLightGray, ModItems.cadColorizerCyan, ModItems.cadColorizerPurple, ModItems.cadColorizerBlue, ModItems.cadColorizerBrown, ModItems.cadColorizerGreen, ModItems.cadColorizerRed, ModItems.cadColorizerBlack});
    }

    public static int slideColor(int[] color, float speed) {
        int n = color.length;
        double t = (double)(ClientTickHandler.total * speed * (float)n) / Math.PI % (double)n;
        int phase = (int)t;
        double dt = t - (double)phase;
        if (dt == 0.0) {
            return color[phase];
        }
        int nextPhase = (phase + 1) % n;
        return ColorHandler.slideColorTime(color[phase], color[nextPhase], (float)(dt * Math.PI));
    }

    public static int slideColor(int color, int secondColor, double speed) {
        return ColorHandler.slideColorTime(color, secondColor, (float)((double)ClientTickHandler.total * speed));
    }

    public static int pulseColor(int source) {
        return ColorHandler.pulseColor(source, 1.0f, 0.2f, 24);
    }

    public static int pulseColor(int source, float speed, int magnitude) {
        return ColorHandler.pulseColor(source, 1.0f, speed, magnitude);
    }

    public static int pulseColor(int source, float multiplier, float speed, int magnitude) {
        int add = (int)(MathHelper.func_76126_a((float)((float)ClientTickHandler.ticksInGame * speed)) * (float)magnitude);
        int red = (0xFF0000 & source) >> 16;
        int green = (0xFF00 & source) >> 8;
        int blue = 0xFF & source;
        int addedRed = MathHelper.func_76125_a((int)((int)(multiplier * (float)(red + add))), (int)0, (int)255);
        int addedGreen = MathHelper.func_76125_a((int)((int)(multiplier * (float)(green + add))), (int)0, (int)255);
        int addedBlue = MathHelper.func_76125_a((int)((int)(multiplier * (float)(blue + add))), (int)0, (int)255);
        return addedRed << 16 | addedGreen << 8 | addedBlue;
    }

    public static int slideColorTime(int color, int secondColor, float t) {
        float shift = (1.0f - MathHelper.func_76134_b((float)t)) / 2.0f;
        if (shift == 0.0f) {
            return color;
        }
        if (shift == 1.0f) {
            return secondColor;
        }
        int redA = (0xFF0000 & color) >> 16;
        int greenA = (0xFF00 & color) >> 8;
        int blueA = 0xFF & color;
        int redB = (0xFF0000 & secondColor) >> 16;
        int greenB = (0xFF00 & secondColor) >> 8;
        int blueB = 0xFF & secondColor;
        int newRed = (int)((float)redA * (1.0f - shift) + (float)redB * shift);
        int newGreen = (int)((float)greenA * (1.0f - shift) + (float)greenB * shift);
        int newBlue = (int)((float)blueA * (1.0f - shift) + (float)blueB * shift);
        return newRed << 16 | newGreen << 8 | newBlue;
    }
}

