/*
 * Decompiled with CFR 0.152.
 */
package fireopal.profundis.features.features;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import fireopal.profundis.features.features.config.AmethystVeinFeatureConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_5216;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6580;

public class AmethystVeinFeature
extends class_3031<AmethystVeinFeatureConfig> {
    private static final class_2248[] AMETHYST_BUDS = new class_2248[]{class_2246.field_27164, class_2246.field_27163, class_2246.field_27162};
    private static final class_4651 OUTLINE_STATE_PROVIDER = new class_6580(956016019L, new class_5216.class_5487(1, 1.0, new double[0]), 0.25f, List.of(class_2246.field_27114.method_9564(), class_2246.field_29032.method_9564()));
    private static final class_4651 SUSPENDED_STATE_PROVIDER = new class_6580(326971689L, new class_5216.class_5487(1, 1.0, new double[0]), 0.025f, List.of(class_2246.field_27159.method_9564(), class_2246.field_27159.method_9564(), class_2246.field_27159.method_9564(), class_2246.field_27114.method_9564(), class_2246.field_27159.method_9564(), class_2246.field_27114.method_9564(), class_2246.field_27159.method_9564(), class_2246.field_27114.method_9564(), class_2246.field_27114.method_9564(), class_2246.field_27114.method_9564(), class_2246.field_27114.method_9564(), class_2246.field_27114.method_9564(), class_2246.field_27114.method_9564(), class_2246.field_27114.method_9564()));

    public AmethystVeinFeature(Codec<AmethystVeinFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<AmethystVeinFeatureConfig> context) {
        class_5819 random = context.method_33654();
        class_2338 origin = context.method_33655();
        class_5281 world = context.method_33652();
        AmethystVeinFeatureConfig config = (AmethystVeinFeatureConfig)context.method_33656();
        return this.generate(world, random, origin, config.undergroundOnly(), config.range().method_35008(random), config.targetCount().method_35008(random), config.radius().method_35008(random));
    }

    private boolean generate(class_5281 world, class_5819 random, class_2338 origin, boolean undergroundOnly, int range, int targetCount, double radius) {
        ArrayList<class_2338.class_2339> targets = new ArrayList<class_2338.class_2339>();
        Iterator iter = class_2338.method_34848((class_5819)random, (int)Integer.MAX_VALUE, (class_2338)origin, (int)range).iterator();
        for (int i = 0; i < targetCount * 16 && targets.size() < targetCount; ++i) {
            class_2338 pos = (class_2338)iter.next();
            if (world.method_22347(pos) || !this.adjacentToAir(world, pos)) continue;
            targets.add(pos.method_25503());
        }
        if (targets.size() == 0) {
            return false;
        }
        ArrayList<Long> futureOutline = new ArrayList<Long>();
        for (class_2338 class_23382 : targets) {
            class_2338 pos;
            boolean factor = true;
            class_243 offsetVector = this.getOffsetVector(origin, class_23382, 1.0);
            double maxDistance = this.distance(origin, class_23382);
            int toDo = (int)Math.ceil(1.0 * Math.sqrt(origin.method_10262((class_2382)class_23382)));
            for (int i = 0; i < toDo && this.adjacentToAir(world, pos = this.vec3dToBlockPos(this.blockPosToVec3d(origin).method_1019(offsetVector.method_1021((double)i)))); ++i) {
                this.setBlocks(world, pos, random, undergroundOnly, radius, maxDistance, this.distance(origin, pos), futureOutline);
            }
        }
        this.setOutline(world, futureOutline, random);
        return true;
    }

    private double distance(class_2338 origin, class_2338 target) {
        return Math.sqrt(origin.method_10262((class_2382)target));
    }

    private class_243 blockPosToVec3d(class_2338 blockPos) {
        return new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
    }

    private class_2338 vec3dToBlockPos(class_243 vec) {
        return new class_2338((int)vec.method_10216(), (int)vec.method_10214(), (int)vec.method_10215());
    }

    private void setBlocks(class_5281 world, class_2338 blockPos, class_5819 random, boolean undergroundOnly, double maxRadius, double maxDistance, double distance, ArrayList<Long> futureOutline) {
        double amethystRadius = (undergroundOnly ? 0.6666666666666666 : 1.0) * (maxRadius - distance / (maxDistance * (undergroundOnly ? 1.0 : 0.5)) * maxRadius) + (double)(!undergroundOnly ? 1 : 0);
        double radius = maxRadius - (double)(undergroundOnly ? 1 : 2) * (distance / maxDistance * maxRadius) + (double)(!undergroundOnly ? 1 : 0);
        int ceilRadius = (int)Math.ceil(radius);
        for (class_2338 pos : class_2338.method_25996((class_2338)blockPos, (int)ceilRadius, (int)ceilRadius, (int)ceilRadius)) {
            if (undergroundOnly && !world.method_8320(pos).method_26225() || !pos.method_19771((class_2382)blockPos, radius)) continue;
            if (pos.method_19771((class_2382)blockPos, amethystRadius)) {
                this.setAmethyst(world, pos, random, undergroundOnly);
                futureOutline.remove(pos.method_10063());
                continue;
            }
            futureOutline.add(pos.method_10063());
        }
    }

    private void setOutline(class_5281 world, ArrayList<Long> outline, class_5819 random) {
        for (long l : outline) {
            class_2338 pos = class_2338.method_10092((long)l);
            class_2680 stateAt = world.method_8320(pos);
            if (random.method_43057() < 0.33333334f || !stateAt.method_26164(class_3481.field_25806)) continue;
            this.method_13153((class_1945)world, pos, OUTLINE_STATE_PROVIDER.method_23455(random, pos));
        }
    }

    private class_243 getOffsetVector(class_2338 origin, class_2338 target, double factor) {
        class_2338 offsetI = origin.method_10081((class_2382)target.method_35830(-1));
        double distance = Math.sqrt(origin.method_10262((class_2382)target));
        return new class_243((double)offsetI.method_10263(), (double)offsetI.method_10264(), (double)offsetI.method_10260()).method_1021(factor / distance);
    }

    private boolean isAmethystBudOrCluster(class_2680 state) {
        for (class_2248 b : AMETHYST_BUDS) {
            if (!state.method_27852(b)) continue;
            return true;
        }
        return state.method_27852(class_2246.field_27161);
    }

    private boolean adjacentToAir(class_5281 world, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            if (!world.method_22347(pos.method_10093(dir)) && !world.method_22351(pos.method_10093(dir))) continue;
            return true;
        }
        return false;
    }

    private void setAmethyst(class_5281 world, class_2338 pos, class_5819 random, boolean undergroundOnly) {
        if (undergroundOnly && this.isAmethystBudOrCluster(world.method_8320(pos))) {
            return;
        }
        ArrayList<Pair> adjacentAir = new ArrayList<Pair>();
        class_2680 state = undergroundOnly ? class_2246.field_27159.method_9564() : SUSPENDED_STATE_PROVIDER.method_23455(random, pos);
        this.method_13153((class_1945)world, pos, state);
        if (!state.method_27852(class_2246.field_27159)) {
            return;
        }
        for (class_2350 dir : class_2350.values()) {
            if (!world.method_22347(pos.method_10093(dir)) && !world.method_22351(pos.method_10093(dir))) continue;
            adjacentAir.add(Pair.of((Object)pos.method_10093(dir), (Object)dir));
        }
        while (adjacentAir.size() > 0) {
            int index = random.method_43048(adjacentAir.size());
            if ((double)random.method_43057() < 0.16666666666666666) {
                Pair pair = (Pair)adjacentAir.get(index);
                this.method_13153((class_1945)world, (class_2338)pair.getFirst(), (class_2680)((class_2680)this.getAmethystCrystal(random).method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)((class_2350)pair.getSecond()))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(world.method_22351((class_2338)pair.getFirst()))));
            }
            adjacentAir.remove(index);
        }
    }

    private class_2248 getAmethystCrystal(class_5819 random) {
        if ((double)random.method_43057() < 0.3333333333333333) {
            return class_2246.field_27161;
        }
        return AMETHYST_BUDS[random.method_43048(AMETHYST_BUDS.length)];
    }
}

