/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.compat.ContraptionCollidable;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.AssociationPool;
import eu.ha3.presencefootsteps.world.Solver;
import eu.ha3.presencefootsteps.world.SoundsKey;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_745;

public class PFSolver
implements Solver {
    private static final double TRAP_DOOR_OFFSET = 0.1;
    private final SoundEngine engine;
    private long lastUpdateTime;
    private final Long2ObjectOpenHashMap<Association> associationCache = new Long2ObjectOpenHashMap();

    public PFSolver(SoundEngine engine) {
        this.engine = engine;
    }

    private class_2680 getBlockStateAt(class_1297 entity, class_2338 pos) {
        class_1937 world = entity.method_37908();
        class_2680 state = world.method_8320(pos);
        if (state.method_26215() && entity instanceof ContraptionCollidable) {
            ContraptionCollidable collidable = (ContraptionCollidable)entity;
            state = collidable.getCollidedStateAt(pos);
        }
        return state.getAppearance((class_1920)world, pos, class_2350.field_11036, state, pos);
    }

    private class_238 getCollider(class_1297 player) {
        class_238 collider = player.method_5829();
        collider = collider.method_989(0.0, -(collider.field_1322 - Math.floor(collider.field_1322)), 0.0);
        double expansionRatio = 0.1;
        collider = collider.method_1014(expansionRatio);
        if (player.method_5624()) {
            collider = collider.method_1009(0.3, 0.5, 0.3);
        }
        return collider;
    }

    private boolean checkCollision(class_1937 world, class_2680 state, class_2338 pos, class_238 collider) {
        class_265 shape = state.method_26220((class_1922)world, pos);
        if (shape.method_1110()) {
            shape = state.method_26218((class_1922)world, pos);
        }
        return shape.method_1110() || shape.method_1107().method_996(pos).method_994(collider);
    }

    @Override
    public Association findAssociation(AssociationPool associations, class_1309 ply, class_2338 pos, String strategy) {
        if (!"find_messy_foliage".equals(strategy)) {
            return Association.NOT_EMITTER;
        }
        pos = pos.method_10084();
        class_2680 above = this.getBlockStateAt((class_1297)ply, pos);
        SoundsKey foliage = this.engine.getIsolator().blocks().getAssociation(above, "foliage");
        if (foliage.isEmitter() && this.engine.getIsolator().blocks().getAssociation(above, "messy") == SoundsKey.MESSY_GROUND) {
            return Association.of(above, pos, ply, SoundsKey.NON_EMITTER, SoundsKey.NON_EMITTER, foliage);
        }
        return Association.NOT_EMITTER;
    }

    @Override
    public Association findAssociation(AssociationPool associations, class_1309 ply, double verticalOffsetAsMinus, boolean isRightFoot) {
        Association cached;
        class_243 vel;
        double rot = Math.toRadians(class_3532.method_15393((float)ply.method_36454()));
        class_243 pos = ply.method_19538();
        float feetDistanceToCenter = 0.2f * (float)(isRightFoot ? -1 : 1) * PlayerUtil.getScale(ply);
        class_2338 footPos = class_2338.method_49637((double)(pos.field_1352 + Math.cos(rot) * (double)feetDistanceToCenter), (double)(ply.method_5829().method_1001(class_2350.class_2351.field_11052) - 0.1 - verticalOffsetAsMinus), (double)(pos.field_1350 + Math.sin(rot) * (double)feetDistanceToCenter));
        if (!(ply instanceof class_745) && (vel = ply.method_18798()).method_1027() != 0.0 && Math.abs(vel.field_1351) < 0.004) {
            return Association.NOT_EMITTER;
        }
        long time = ply.method_37908().method_8510();
        if (time != this.lastUpdateTime) {
            this.lastUpdateTime = time;
            this.associationCache.clear();
        }
        if ((cached = (Association)this.associationCache.get(footPos.method_10063())) != null) {
            return cached;
        }
        class_238 collider = this.getCollider((class_1297)ply);
        class_2338.class_2339 mutableFootPos = footPos.method_25503();
        if (feetDistanceToCenter > 1.0f) {
            for (class_2338 underfootPos : class_2338.method_25996((class_2338)footPos, (int)((int)feetDistanceToCenter), (int)2, (int)((int)feetDistanceToCenter))) {
                mutableFootPos.method_10101((class_2382)underfootPos);
                Association assos = this.findAssociation(associations, ply, collider, underfootPos, mutableFootPos);
                if (!assos.isResult()) continue;
                this.associationCache.put(footPos.method_10063(), (Object)assos);
                return assos;
            }
        }
        Association assos = this.findAssociation(associations, ply, collider, footPos, mutableFootPos);
        this.associationCache.put(footPos.method_10063(), (Object)assos);
        return assos;
    }

    private Association findAssociation(AssociationPool associations, class_1309 player, class_238 collider, class_2338 originalFootPos, class_2338.class_2339 pos) {
        boolean isXdangMax;
        Association association = this.findAssociation(associations, player, pos, collider);
        if (association.isResult()) {
            return association;
        }
        pos.method_10101((class_2382)originalFootPos);
        double xdang = (player.method_23317() - (double)pos.method_10263()) * 2.0 - 1.0;
        double zdang = (player.method_23321() - (double)pos.method_10260()) * 2.0 - 1.0;
        if (Math.max(Math.abs(xdang), Math.abs(zdang)) <= (double)0.2f) {
            return association;
        }
        boolean bl = isXdangMax = Math.abs(xdang) > Math.abs(zdang);
        association = this.findAssociation(associations, player, isXdangMax ? pos.method_10104(class_2350.field_11034, xdang > 0.0 ? 1 : -1) : pos.method_10104(class_2350.field_11035, zdang > 0.0 ? 1 : -1), collider);
        if (association.isResult()) {
            return association;
        }
        pos.method_10101((class_2382)originalFootPos);
        return this.findAssociation(associations, player, isXdangMax ? pos.method_10104(class_2350.field_11035, zdang > 0.0 ? 1 : -1) : pos.method_10104(class_2350.field_11034, xdang > 0.0 ? 1 : -1), collider);
    }

    private Association findAssociation(AssociationPool associations, class_1309 entity, class_2338.class_2339 pos, class_238 collider) {
        associations.reset();
        class_2680 target = this.getBlockStateAt((class_1297)entity, (class_2338)pos);
        pos.method_10098(class_2350.field_11036);
        boolean hasRain = entity.method_37908().method_8520((class_2338)pos);
        class_2680 carpet = this.getBlockStateAt((class_1297)entity, (class_2338)pos);
        class_265 shape = carpet.method_26220((class_1922)entity.method_37908(), (class_2338)pos);
        boolean isValidCarpet = !shape.method_1110() && shape.method_1105(class_2350.class_2351.field_11052) < (double)0.2f && shape.method_1105(class_2350.class_2351.field_11052) < collider.method_1001(class_2350.class_2351.field_11052) + (double)0.1f;
        SoundsKey association = SoundsKey.UNASSIGNED;
        SoundsKey foliage = SoundsKey.UNASSIGNED;
        SoundsKey wetAssociation = SoundsKey.UNASSIGNED;
        if (isValidCarpet && (association = associations.get((class_2338)pos, carpet, "carpet")).isEmitter()) {
            target = carpet;
        } else {
            pos.method_10098(class_2350.field_11033);
            if (target.method_26215()) {
                pos.method_10098(class_2350.field_11033);
                class_2680 fence = this.getBlockStateAt((class_1297)entity, (class_2338)pos);
                association = associations.get((class_2338)pos, fence, "bigger");
                if (association.isResult()) {
                    carpet = target;
                    target = fence;
                } else {
                    pos.method_10098(class_2350.field_11036);
                }
            }
            if (!association.isResult()) {
                association = associations.get((class_2338)pos, target, "");
            }
            if (this.engine.getConfig().foliageSoundsVolume.get() > 0 && (entity.method_6118(class_1304.field_6166).method_7960() || entity.method_5624()) && association.isEmitter() && carpet.method_26220((class_1922)entity.method_37908(), (class_2338)pos).method_1110()) {
                pos.method_10098(class_2350.field_11036);
                foliage = associations.get((class_2338)pos, carpet, "foliage");
                pos.method_10098(class_2350.field_11033);
            }
        }
        if (association.isResult() && !this.checkCollision(entity.method_37908(), target, (class_2338)pos, collider)) {
            association = SoundsKey.NON_EMITTER;
        }
        if (association.isEmitter() && (hasRain || !associations.wasLastMatchGolem() && (target.method_26227().method_15767(class_3486.field_15517) || carpet.method_26227().method_15767(class_3486.field_15517)))) {
            wetAssociation = associations.get((class_2338)pos, target, "wet");
        }
        return Association.of(target, (class_2338)pos, entity, association, wetAssociation, foliage);
    }
}

