/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.stream.JsonWriter;
import com.minelittlepony.common.util.GamePaths;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2498;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockReport {
    private final Path loc;

    public BlockReport(String baseName) {
        this.loc = BlockReport.getUniqueFileName(GamePaths.getGameDirectory().resolve("presencefootsteps"), baseName, ".json");
    }

    public CompletableFuture<?> execute(@Nullable Predicate<class_2680> filter) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.writeReport(filter);
                this.printResults();
            }
            catch (Exception e) {
                BlockReport.addMessage((class_2561)class_2561.method_43469((String)"pf.report.error", (Object[])new Object[]{e.getMessage()}).method_27694(s -> s.method_10977(class_124.field_1061)));
            }
        });
    }

    private void writeReport(@Nullable Predicate<class_2680> filter) throws IOException {
        Files.createDirectories(this.loc.getParent(), new FileAttribute[0]);
        try (JsonObjectWriter writer = JsonObjectWriter.of(new JsonWriter((Writer)Files.newBufferedWriter(this.loc, new OpenOption[0])));){
            writer.object(() -> {
                Object2ObjectOpenHashMap groups = new Object2ObjectOpenHashMap();
                writer.object("blocks", () -> this.lambda$writeReport$4(writer, (Map)groups, filter));
                writer.array("unmapped_entities", () -> writer.each(class_7923.field_41177, type -> {
                    class_2960 id = class_7923.field_41177.method_10221(type);
                    if (!PresenceFootsteps.getInstance().getEngine().getIsolator().getLocomotionMap().contains(id) && type.method_5883((class_1937)class_310.method_1551().field_1687) instanceof class_1309) {
                        writer.writer().value(id.toString());
                    }
                }));
                writer.object("primitives", () -> BlockReport.lambda$writeReport$8(writer, (Map)groups));
            });
        }
    }

    private String getSoundData(@Nullable class_2498 group) {
        if (group == null) {
            return "NULL";
        }
        if (group.method_10594() == null) {
            return "NO_SOUND";
        }
        return group.method_10594().method_14833().method_12832();
    }

    private String getClassData(class_2680 state) {
        @Nullable String canonicalName = state.method_26204().getClass().getCanonicalName();
        if (canonicalName == null) {
            return "<anonymous>";
        }
        return FabricLoader.getInstance().getMappingResolver().unmapClassName("named", canonicalName);
    }

    private String getTagData(class_2680 state) {
        return class_7923.field_41175.method_40273().filter(arg_0 -> ((class_2680)state).method_26164(arg_0)).map(class_6862::comp_327).map(class_2960::toString).collect(Collectors.joining(","));
    }

    private void printResults() {
        BlockReport.addMessage((class_2561)class_2561.method_43469((String)"pf.report.save", (Object[])new Object[]{class_2561.method_43470((String)this.loc.getFileName().toString()).method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11746, this.loc.toString())).method_27706(class_124.field_1073))}).method_27694(s -> s.method_10977(class_124.field_1060)));
    }

    public static void addMessage(class_2561 text) {
        class_310.method_1551().field_1705.method_1743().method_1812(text);
    }

    static Path getUniqueFileName(Path directory, String baseName, String ext) {
        Path loc = null;
        int counter = 0;
        while (loc == null || Files.exists(loc, new LinkOption[0])) {
            loc = directory.resolve(baseName + (String)(counter == 0 ? "" : "_" + counter) + ext);
            ++counter;
        }
        return loc;
    }

    private static /* synthetic */ void lambda$writeReport$8(JsonObjectWriter writer, Map groups) throws IOException {
        writer.each(groups.values(), group -> {
            String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(group.field_11540), Float.valueOf(group.field_11539));
            writer.field(group.method_10594().method_14833().toString() + "@" + substrate, PresenceFootsteps.getInstance().getEngine().getIsolator().getPrimitiveMap().getAssociation((class_2498)group, substrate));
        });
    }

    private /* synthetic */ void lambda$writeReport$4(JsonObjectWriter writer, Map groups, Predicate filter) throws IOException {
        writer.each(class_7923.field_41175, block -> {
            class_2680 state = block.method_9564();
            class_2498 group = block.method_9564().method_26231();
            if (group != null && group.method_10594() != null) {
                String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(group.field_11540), Float.valueOf(group.field_11539));
                groups.put(group.method_10594().method_14833().toString() + "@" + substrate, group);
            }
            if (filter == null || filter.test(state)) {
                writer.object(class_7923.field_41175.method_10221(block).toString(), () -> {
                    writer.field("class", this.getClassData(state));
                    writer.field("tags", this.getTagData(state));
                    writer.field("sound", this.getSoundData(group));
                    writer.field("association", PresenceFootsteps.getInstance().getEngine().getIsolator().getBlockMap().getAssociation(state, ""));
                });
            }
        });
    }
}

