/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.ender;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.block.IOwnable;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.util.Player;
import owmii.lib.util.Server;
import owmii.lib.util.math.RangedInt;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.ender.EnderNetwork;

public class AbstractEnderTile<V extends Enum<V>, C extends IEnergyConfig<V>, B extends AbstractEnergyBlock<V, C, B>>
extends AbstractEnergyStorage<V, C, B>
implements IOwnable,
IInventoryHolder {
    private final RangedInt channel = new RangedInt(12);
    @Nullable
    private GameProfile owner;
    private boolean flag;

    public AbstractEnderTile(TileEntityType<?> type, V variant) {
        super(type, variant);
    }

    public void readStorable(CompoundNBT nbt) {
        super.readStorable(nbt);
        this.channel.read(nbt, "channel");
        if (nbt.func_186855_b("owner_id")) {
            this.owner = new GameProfile(nbt.func_186857_a("owner_id"), nbt.func_74779_i("owner_name"));
        }
    }

    public CompoundNBT writeStorable(CompoundNBT nbt) {
        this.channel.writ(nbt, "channel");
        if (this.owner != null) {
            nbt.func_186854_a("owner_id", this.owner.getId());
            nbt.func_74778_a("owner_name", this.owner.getName());
        }
        return super.writeStorable(nbt);
    }

    protected void onFirstTick(World world) {
        super.onFirstTick(world);
        this.getEnergy().setTransfer(this.getEnergyTransfer());
    }

    protected int postTick(World world) {
        if (!this.isRemote() && this.energy.clone(this.getEnergy())) {
            this.sync(5);
        }
        return this.chargeItems(1, 3) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    public void onSlotChanged(int slot) {
        if (this.field_145850_b != null && slot == 0) {
            ItemStack stack = this.inv.getStackInSlot(0);
            if (this.isExtender() && stack.func_77973_b() instanceof IEnderExtender) {
                Energy energy = this.getEnergy();
                IEnderExtender e = (IEnderExtender)stack.func_77973_b();
                long cap = e.getExtendedCapacity(stack);
                long newCap = energy.getCapacity() + cap;
                if (cap <= Energy.MAX && newCap > 0L && newCap <= Energy.MAX) {
                    if (!this.isRemote()) {
                        energy.setCapacity(newCap);
                        energy.setStored(e.getExtendedEnergy(stack) + this.getEnergy().getStored());
                        this.setEnergy(energy);
                    }
                    stack.func_190918_g(1);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_193777_bb, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    protected long receiveEnergy(int maxReceive, boolean simulate, @Nullable Direction side) {
        long l = super.receiveEnergy(maxReceive, simulate, side);
        this.setEnergy(this.getEnergy());
        return l;
    }

    protected long extractEnergy(int maxExtract, boolean simulate, @Nullable Direction side) {
        long l = super.extractEnergy(maxExtract, simulate, side);
        this.setEnergy(this.getEnergy());
        return l;
    }

    public boolean canExtractEnergy(@Nullable Direction side) {
        return this.checkRedstone() && super.canExtractEnergy(side);
    }

    public boolean canReceiveEnergy(@Nullable Direction side) {
        return this.checkRedstone() && super.canReceiveEnergy(side);
    }

    public void onPlaced(World world, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlaced(world, state, placer, stack);
        if (this.getOwner() == null && placer instanceof ServerPlayerEntity && !Player.isFake((PlayerEntity)((PlayerEntity)placer))) {
            this.setOwner(((ServerPlayerEntity)placer).func_146103_bH());
        }
    }

    public void setEnergy(Energy energy) {
        if (!this.isRemote() && this.owner != null) {
            EnderNetwork network = (EnderNetwork)Server.getData(EnderNetwork::new);
            network.setEnergy(this.owner.getId(), this.channel.get(), energy);
        }
    }

    public boolean isExtender() {
        return true;
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable GameProfile owner) {
        this.owner = owner;
    }

    public Energy getEnergy() {
        if (this.isRemote()) {
            return this.energy;
        }
        return ((EnderNetwork)Server.getData(EnderNetwork::new)).getEnergy(this, this.channel.get()).setTransfer(this.getEnergyTransfer());
    }

    public RangedInt getChannel() {
        return this.channel;
    }

    public int getMaxChannels() {
        return 0;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        if (slot == 0) {
            if (stack.func_77973_b() instanceof IEnderExtender) {
                IEnderExtender extender = (IEnderExtender)stack.func_77973_b();
                long l = extender.getExtendedCapacity(stack);
                return l > 0L && l + this.getEnergy().getCapacity() <= Energy.MAX;
            }
            return false;
        }
        return Energy.chargeable((ItemStack)stack);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

