/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.transmitter;

import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.compat.curios.CuriosCompat;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.util.Player;
import owmii.lib.util.Stack;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.transmitter.PlayerTransmitterBlock;
import owmii.powah.config.PlayerTransmitterConfig;
import owmii.powah.item.BindingCardItem;

public class PlayerTransmitterTile
extends AbstractEnergyStorage<Tier, PlayerTransmitterConfig, PlayerTransmitterBlock>
implements IInventoryHolder {
    public PlayerTransmitterTile(Tier variant) {
        super(Tiles.PLAYER_TRANSMITTER, (Enum)variant);
        this.inv.add(1);
    }

    public PlayerTransmitterTile() {
        this(Tier.STARTER);
    }

    protected int postTick(World world) {
        BindingCardItem card;
        Optional<ServerPlayerEntity> op;
        ItemStack stack;
        long extracted = 0L;
        if (!this.isRemote() && this.checkRedstone() && (stack = this.inv.getFirst()).func_77973_b() instanceof BindingCardItem && (op = (card = (BindingCardItem)stack.func_77973_b()).getPlayer(stack)).isPresent()) {
            ServerPlayerEntity player = op.get();
            if (card.isMultiDim(stack) || player.field_70170_p.func_230315_m_().equals(world.func_230315_m_())) {
                int received;
                long amount;
                long charging = ((PlayerTransmitterConfig)this.getConfig()).getChargingSpeed((Tier)this.variant);
                for (ItemStack stack1 : Player.invStacks((PlayerEntity)player)) {
                    if (stack1.func_190926_b() || !Energy.chargeable((ItemStack)stack1)) continue;
                    amount = Math.min(charging, this.getEnergy().getStored());
                    received = Energy.receive((ItemStack)stack1, (long)amount, (boolean)false);
                    extracted += this.extractEnergy(received, false, null);
                }
                for (ItemStack stack1 : CuriosCompat.getAllStacks((PlayerEntity)player)) {
                    if (stack1.func_190926_b() || !Energy.chargeable((ItemStack)stack1)) continue;
                    amount = Math.min(charging, this.getEnergy().getStored());
                    received = Energy.receive((ItemStack)stack1, (long)amount, (boolean)false);
                    extracted += this.extractEnergy(received, false, null);
                }
            }
        }
        return extracted > 0L ? 5 : -1;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        return Stack.getTagOrEmpty((ItemStack)stack).func_186855_b("bound_player_id");
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    public boolean keepEnergy() {
        return true;
    }
}

