/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.Pair;
import owmii.lib.block.AbstractEnergyProvider;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.block.ITankHolder;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.logistics.fluid.Tank;
import owmii.lib.util.Ticker;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.reactor.Builder;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.config.generator.ReactorConfig;
import owmii.powah.item.Itms;

public class ReactorTile
extends AbstractEnergyProvider<Tier, ReactorConfig, ReactorBlock>
implements IInventoryHolder,
ITankHolder {
    private final Builder builder = new Builder(this);
    public final Ticker fuel = new Ticker(1000.0);
    public final Ticker carbon = Ticker.empty();
    public final Ticker redstone = Ticker.empty();
    public final Ticker solidCoolant = Ticker.empty();
    public int solidCoolantTemp;
    public final Ticker temp = new Ticker(1000.0);
    private int redstoneTemp;
    private int carbonTemp;
    private int baseTemp;
    public final Ticker bright = new Ticker(20.0);
    private boolean running;
    private boolean genModeOn;
    private boolean generate = true;

    public ReactorTile(Tier variant) {
        super(Tiles.REACTOR, (Enum)variant);
        this.tank.setCapacity(1000).validate(stack -> PowahAPI.COOLANTS.containsKey(stack.getFluid())).setChange(() -> this.sync(10));
        this.inv.add(5);
    }

    public ReactorTile() {
        this(Tier.STARTER);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.baseTemp = nbt.func_74762_e("base_temp");
        this.carbonTemp = nbt.func_74762_e("carbon_temp");
        this.redstoneTemp = nbt.func_74762_e("redstone_temp");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74768_a("base_temp", this.baseTemp);
        nbt.func_74768_a("carbon_temp", this.carbonTemp);
        nbt.func_74768_a("redstone_temp", this.redstoneTemp);
        return super.func_189515_b(nbt);
    }

    public void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.builder.read(nbt);
        this.fuel.read(nbt, "fuel");
        this.carbon.read(nbt, "carbon");
        this.redstone.read(nbt, "redstone");
        this.solidCoolant.read(nbt, "solid_coolant");
        this.solidCoolantTemp = nbt.func_74762_e("solid_coolant_temp");
        this.running = nbt.func_74767_n("running");
        this.genModeOn = nbt.func_74767_n("gen_mode");
        this.generate = nbt.func_74767_n("generate");
        this.temp.read(nbt, "temperature");
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        this.builder.write(nbt);
        this.fuel.write(nbt, "fuel");
        this.carbon.write(nbt, "carbon");
        this.redstone.write(nbt, "redstone");
        this.solidCoolant.write(nbt, "solid_coolant");
        nbt.func_74768_a("solid_coolant_temp", this.solidCoolantTemp);
        nbt.func_74757_a("running", this.running);
        nbt.func_74757_a("gen_mode", this.genModeOn);
        nbt.func_74757_a("generate", this.generate);
        this.temp.write(nbt, "temperature");
        return super.writeSync(nbt);
    }

    protected int postTick(World world) {
        if (this.isRemote() || !this.builder.isDone(world)) {
            return -1;
        }
        long extracted = this.chargeItems(1);
        boolean flag = false;
        boolean flag2 = false;
        if (this.checkRedstone() && this.generate) {
            boolean generating = !this.energy.isFull() && !this.fuel.isEmpty();
            boolean b0 = this.processFuel(world);
            boolean b1 = this.processCarbon(world, generating);
            boolean b2 = this.processRedstone(world, generating);
            boolean b3 = this.processTemperature(world, generating);
            if (b0 || b1 || b2 || b3) {
                flag = true;
            }
            if (generating) {
                this.fuel.back(this.calcConsumption());
                this.energy.produce((long)this.calcProduction());
                flag = true;
                flag2 = true;
            }
            if (flag && this.isContainerOpen) {
                this.sync(3);
            }
        }
        this.checkGenMode();
        for (Direction direction : Direction.values()) {
            if (!this.canExtractEnergy(direction)) continue;
            long amount = Math.min(this.getEnergyTransfer(), this.getEnergy().getStored());
            BlockPos pos = this.field_174879_c.func_177967_a(direction, direction.func_176740_k().func_176722_c() ? 2 : (direction.equals((Object)Direction.UP) ? 4 : 1));
            int received = Energy.receive((TileEntity)world.func_175625_s(pos), (Direction)direction, (long)amount, (boolean)false);
            extracted += this.extractEnergy(received, false, direction);
        }
        if (this.running != flag2) {
            this.running = flag2;
            this.sync(5);
        }
        return extracted > 0L ? 5 : -1;
    }

    protected void clientTick(World world) {
        if (this.running) {
            this.bright.onward();
        } else {
            this.bright.back();
        }
    }

    private void checkGenMode() {
        if (this.genModeOn) {
            if (this.energy.isFull()) {
                this.generate = false;
            } else if (this.energy.getPercent() <= 70L) {
                this.generate = true;
            }
        }
    }

    public double calcProduction() {
        double d = this.carbon.isEmpty() ? 1.0 : 1.2;
        double d1 = this.redstone.isEmpty() ? 1.0 : 1.4;
        return (1.0 - this.calc()) * (this.fuel.getTicks() / 100.0) * (double)this.getGeneration() * d * d1;
    }

    public double calcConsumption() {
        if (this.running) {
            double d1 = 1.0 + (double)((Tier)this.variant).ordinal() * 0.25;
            return (1.0 + (double)((Tier)this.variant).ordinal() * 0.25) * this.calc();
        }
        return 0.0;
    }

    public double calc() {
        double d0 = this.redstone.isEmpty() ? 1.0 : 1.4;
        return this.temp.getTicks() / 1000.0 * 0.98 / 2.0 * d0;
    }

    private boolean processTemperature(World world, boolean generating) {
        ItemStack stack;
        boolean flag = false;
        if (this.solidCoolant.isEmpty() && !(stack = this.inv.getStackInSlot(4)).func_190926_b()) {
            Pair<Integer, Integer> coolant = PowahAPI.getSolidCoolant((IItemProvider)stack.func_77973_b());
            int size = (Integer)coolant.getLeft();
            int temp = (Integer)coolant.getRight();
            if (size > 0 && temp < 2) {
                this.solidCoolant.setAll((double)size);
                this.solidCoolantTemp = temp;
                stack.func_190918_g(1);
                flag = true;
            }
        }
        if (!this.solidCoolant.isEmpty()) {
            if (!this.tank.isEmpty() && generating && this.ticks % 40 == 0) {
                this.solidCoolant.back();
                if (this.solidCoolant.isEmpty()) {
                    this.solidCoolant.setMax(0.0);
                }
                flag = true;
            }
        } else {
            this.solidCoolantTemp = 0;
        }
        double temp = Math.min((double)(this.baseTemp + this.carbonTemp + this.redstoneTemp), this.temp.getMax());
        if (!this.tank.isEmpty()) {
            int coldness = PowahAPI.getCoolant(this.tank.getFluid().getFluid()) - 2;
            int i = Math.abs(coldness + this.solidCoolantTemp) + 1;
            temp /= (double)i;
            this.sync(5);
        }
        if (this.temp.getTicks() < temp) {
            this.temp.onward();
            flag = true;
        }
        if (this.ticks % (this.tank.isEmpty() ? 5 : (this.solidCoolant.isEmpty() ? 3 : 1)) == 0 && this.temp.getTicks() > temp) {
            this.temp.back();
            flag = true;
        }
        return flag;
    }

    private boolean processRedstone(World world, boolean generating) {
        boolean flag = false;
        if (this.redstone.isEmpty()) {
            ItemStack stack = this.inv.getStackInSlot(3);
            if (stack.func_77973_b() == Items.field_151137_ax) {
                this.redstone.setAll(18.0);
            } else if (stack.func_77973_b() == Items.field_221858_em) {
                this.redstone.setAll(162.0);
            }
            this.redstoneTemp = 120;
            stack.func_190918_g(1);
            flag = true;
        }
        if (!this.redstone.isEmpty()) {
            if (generating && this.ticks % 40 == 0) {
                this.redstone.back();
                if (this.redstone.isEmpty()) {
                    this.redstone.setMax(0.0);
                }
                flag = true;
            }
        } else {
            this.redstoneTemp = 0;
        }
        return flag;
    }

    private boolean processCarbon(World world, boolean generating) {
        int carbon;
        ItemStack stack;
        boolean flag = false;
        if (this.carbon.isEmpty() && !(stack = this.inv.getStackInSlot(2)).func_190926_b() && (carbon = ForgeHooks.getBurnTime((ItemStack)stack)) > 0) {
            this.carbon.setAll((double)carbon);
            this.carbonTemp = 180;
            stack.func_190918_g(1);
            flag = true;
        }
        if (!this.carbon.isEmpty()) {
            if (generating) {
                this.carbon.back();
                if (this.carbon.isEmpty()) {
                    this.carbon.setMax(0.0);
                }
            }
        } else {
            this.carbonTemp = 0;
        }
        return flag;
    }

    private boolean processFuel(World world) {
        ItemStack stack;
        boolean flag = false;
        if (this.fuel.getTicks() <= 900.0 && (stack = this.inv.getStackInSlot(1)).func_77973_b() == Itms.URANINITE) {
            this.fuel.add(100.0);
            this.baseTemp = 700;
            stack.func_190918_g(1);
            flag = true;
        }
        if (this.fuel.isEmpty()) {
            this.baseTemp = 0;
        }
        return flag;
    }

    public void onPlaced(World world, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlaced(world, state, placer, stack);
        this.builder.shuffle();
    }

    public void demolish(World world) {
        this.builder.demolish(world);
        while (this.fuel.getTicks() >= 100.0) {
            Block.func_180635_a((World)world, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((IItemProvider)Itms.URANINITE));
            this.fuel.back(100.0);
        }
    }

    public boolean isBuilt() {
        return this.builder.built;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        if (slot == 1) {
            return stack.func_77973_b() == Itms.URANINITE;
        }
        if (slot == 2) {
            return ForgeHooks.getBurnTime((ItemStack)stack) > 0 && !stack.hasContainerItem();
        }
        if (slot == 3) {
            return stack.func_77973_b() == Items.field_151137_ax || stack.func_77973_b() == Items.field_221858_em;
        }
        if (slot == 4) {
            Pair<Integer, Integer> coolant = PowahAPI.getSolidCoolant((IItemProvider)stack.func_77973_b());
            return (Integer)coolant.getLeft() > 0 && (Integer)coolant.getRight() < 2;
        }
        return Energy.chargeable((ItemStack)stack);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    public Tank getTank() {
        return this.tank;
    }

    public boolean keepFluid() {
        return false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isGenModeOn() {
        return this.genModeOn;
    }

    public void setGenModeOn(boolean genModeOn) {
        this.genModeOn = genModeOn;
        this.sync();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b(1.0, 3.0, 1.0);
    }
}

