/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.AbstractGeneratorBlock;
import owmii.lib.block.AbstractTileEntity;
import owmii.lib.client.util.Text;
import owmii.lib.client.wiki.page.panel.InfoBox;
import owmii.lib.item.EnergyBlockItem;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.logistics.inventory.AbstractContainer;
import owmii.lib.util.Util;
import owmii.powah.block.Tier;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.client.render.tile.ReactorRenderer;
import owmii.powah.config.Configs;
import owmii.powah.config.generator.ReactorConfig;
import owmii.powah.inventory.ReactorContainer;
import owmii.powah.item.ReactorItem;

public class ReactorBlock
extends AbstractGeneratorBlock<Tier, ReactorConfig, ReactorBlock> {
    public static final BooleanProperty CORE = BooleanProperty.func_177716_a((String)"core");

    public ReactorBlock(AbstractBlock.Properties properties, Tier variant) {
        super(properties, (Enum)variant);
        this.setStateProps(state -> (BlockState)state.func_206870_a((Property)CORE, (Comparable)Boolean.valueOf(false)));
    }

    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new ReactorItem(this, properties, group);
    }

    public ReactorConfig getConfig() {
        return Configs.REACTOR;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((Boolean)state.func_177229_b((Property)CORE)).booleanValue()) {
            return new ReactorTile((Tier)this.variant);
        }
        return new ReactorPartTile((Tier)this.variant);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return context.func_195999_j() != null ? (BlockState)this.func_176223_P().func_206870_a((Property)CORE, (Comparable)Boolean.valueOf(true)) : super.func_196258_a(context);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ReactorPartTile reactor;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile reactor2 = (ReactorTile)tileentity;
            if (reactor2.isBuilt()) {
                if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)reactor2.getTank())) {
                    reactor2.sync();
                    return ActionResultType.SUCCESS;
                }
                return super.func_225533_a_(state, world, pos, player, hand, result);
            }
        } else if (tileentity instanceof ReactorPartTile && (reactor = (ReactorPartTile)tileentity).isBuilt() && reactor.core().isPresent()) {
            return ((ReactorBlock)reactor.getBlock()).func_225533_a_(state, world, reactor.getCorePos(), player, hand, result);
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, PlayerInventory inventory, AbstractTileEntity te, BlockRayTraceResult result) {
        if (te instanceof ReactorTile) {
            return new ReactorContainer(id, inventory, (ReactorTile)te);
        }
        return null;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile tile = (ReactorTile)tileentity;
            tile.demolish(world);
        } else if (tileentity instanceof ReactorPartTile) {
            ReactorPartTile tile = (ReactorPartTile)tileentity;
            tile.demolish(world);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{CORE});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderByItem(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer rtb, int light, int ov) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227862_a_(1.0f, -1.0f, -1.0f);
        IVertexBuilder buffer = rtb.getBuffer(ReactorRenderer.CUBE_MODEL.func_228282_a_(new ResourceLocation("powah", "textures/model/tile/reactor_block_" + ((Tier)this.getVariant()).getName() + ".png")));
        ReactorRenderer.CUBE_MODEL.func_225598_a_(matrix, buffer, light, ov, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.func_227865_b_();
    }

    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new TranslationTextComponent("info.powah.generation.factor").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new StringTextComponent(Util.numFormat((long)this.getConfig().getGeneration((Tier)this.variant))).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick")).func_240699_a_(TextFormatting.DARK_GRAY)));
    }

    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent((ItemStack)stack, storage -> {
            if (storage instanceof Energy.Item) {
                Energy.Item energy = (Energy.Item)storage;
                box.set((TextComponent)new TranslationTextComponent("info.lollipop.capacity"), (TextComponent)new TranslationTextComponent("info.lollipop.fe", new Object[]{Util.addCommas((long)energy.getCapacity())}));
                box.set((TextComponent)new TranslationTextComponent("info.powah.generation.factor"), (TextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas((long)this.getConfig().getGeneration((Tier)this.variant))}));
                box.set((TextComponent)new TranslationTextComponent("info.lollipop.max.extract"), (TextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas((long)energy.getMaxExtract())}));
            }
        });
        return box;
    }
}

